/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.java.BuilderMethodCallChainsExtractor;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Check(id="java:S5659", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JWTWithStrongCipherCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        JavaImportSensitiveTypeResolver javaImportSensitiveTypeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        boolean checkJwtBuilder = javaImportSensitiveTypeResolver.isImported("io.jsonwebtoken.JwtBuilder");
        boolean checkJwtParser = javaImportSensitiveTypeResolver.isImported("io.jsonwebtoken.JwtParser");
        boolean checkAuth0JWT = javaImportSensitiveTypeResolver.isImported("com.auth0.jwt.JWT");
        if (!(checkJwtBuilder || checkJwtParser || checkAuth0JWT)) {
            return;
        }
        for (ShallowEntity method : methods) {
            BuilderMethodCallChainsExtractor.MethodCallChains chains = BuilderMethodCallChainsExtractor.extractMethodCallChains((ShallowEntity)method);
            this.analyzeMethodCallChains(method, chains, checkJwtBuilder, checkJwtParser, checkAuth0JWT);
        }
    }

    private void analyzeMethodCallChains(ShallowEntity method, BuilderMethodCallChainsExtractor.MethodCallChains chains, boolean checkJwtBuilder, boolean checkJwtParser, boolean checkAuth0JWT) {
        for (int chainIdx = 0; chainIdx < chains.chains().size(); ++chainIdx) {
            BuilderMethodCallChainsExtractor.MethodCallChain chain = (BuilderMethodCallChainsExtractor.MethodCallChain)chains.chains().get(chainIdx);
            for (int callIdx = 0; callIdx < chain.calls().size(); ++callIdx) {
                if (checkJwtBuilder) {
                    this.analyzeCompactCall(method, chains, chain, callIdx, chainIdx);
                }
                if (checkJwtParser) {
                    this.analyzeParseCall(chains, chain, callIdx, chainIdx);
                }
                if (!checkAuth0JWT) continue;
                this.analyzeAlgorithmNoneCall(chain, callIdx);
            }
        }
    }

    private void analyzeAlgorithmNoneCall(BuilderMethodCallChainsExtractor.MethodCallChain chain, int callIdx) {
        TokenPattern algorithmNonePackage = TokenPattern.of().optional(new Object[]{TokenPattern.text((String)"com"), ETokenType.DOT, TokenPattern.text((String)"auth0"), ETokenType.DOT, TokenPattern.text((String)"jwt"), ETokenType.DOT, TokenPattern.text((String)"algorithms"), ETokenType.DOT});
        TokenPattern algorithmNoneClass = TokenPattern.of().optional(new Object[]{TokenPattern.of().sequence(new Object[]{algorithmNonePackage, TokenPattern.text((String)"Algorithm"), ETokenType.DOT})});
        TokenPattern algorithmNoneMethodCall = TokenPattern.of().sequence(new Object[]{algorithmNoneClass, TokenPattern.text((String)"none"), ETokenType.LPAREN, ETokenType.RPAREN});
        if (((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier().getLast()).getText().equals("require") && ((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).arguments().size() == 1 && algorithmNoneMethodCall.matchFully((List)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).arguments().getFirst()) != null) {
            this.buildFinding("Insecure call to `com.auth0.jwt.JWT.require` with `Algorithm.none`", this.buildLocation().forTokens(((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier())).createAndStore();
        }
        if (((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier().getLast()).getText().equals("sign") && ((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).arguments().size() == 1 && algorithmNoneMethodCall.matchFully((List)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).arguments().getFirst()) != null) {
            this.buildFinding("Insecure call to `sign` with `Algorithm.none`", this.buildLocation().forTokens(((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier())).createAndStore();
        }
    }

    private void analyzeParseCall(BuilderMethodCallChainsExtractor.MethodCallChains chains, BuilderMethodCallChainsExtractor.MethodCallChain chain, int callIdx, int chainIdx) {
        if (!((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier().getLast()).getText().equals("parse")) {
            return;
        }
        List relatedPrevious = chains.getRelated(chainIdx);
        for (BuilderMethodCallChainsExtractor.MethodCallChain previous : relatedPrevious) {
            for (int k = 0; k < previous.calls().size(); ++k) {
                if (!TokenStreamTextUtils.concatTokenTexts((List)((BuilderMethodCallChainsExtractor.MethodCall)previous.calls().get(k)).identifier()).equals("Jwts.parser")) continue;
                this.buildFinding("Insecure call to `io.jsonwebtoken.JwtParser.parse` which does not verify signature", this.buildLocation().forToken((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier().getLast())).createAndStore();
                return;
            }
        }
    }

    private void analyzeCompactCall(ShallowEntity method, BuilderMethodCallChainsExtractor.MethodCallChains chains, BuilderMethodCallChainsExtractor.MethodCallChain chain, int callIdx, int chainIdx) {
        if (!((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier().getLast()).getText().equals("compact")) {
            return;
        }
        if (((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().getFirst()).identifier().size() == 3) {
            String potentialAttribute = ((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().getFirst()).identifier().getFirst()).getText();
            List attributes = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(List.of(Objects.requireNonNull(method.getParent())), EnumSet.of(EShallowEntityType.ATTRIBUTE), Set.of("attribute"));
            for (ShallowEntity attribute : attributes) {
                if (!Objects.equals(attribute.getName(), potentialAttribute)) continue;
                return;
            }
        }
        List relatedPrevious = chains.getRelated(chainIdx);
        for (BuilderMethodCallChainsExtractor.MethodCallChain previous : relatedPrevious) {
            for (int k = 0; k < previous.calls().size(); ++k) {
                if (!((IToken)((BuilderMethodCallChainsExtractor.MethodCall)previous.calls().get(k)).identifier().getLast()).getText().equals("signWith")) continue;
                return;
            }
            if (((BuilderMethodCallChainsExtractor.MethodCall)previous.calls().getFirst()).identifier().size() != 1) continue;
            return;
        }
        this.buildFinding("Insecure call to `io.jsonwebtoken.JwtBuilder.compact` without signing", this.buildLocation().forToken((IToken)((BuilderMethodCallChainsExtractor.MethodCall)chain.calls().get(callIdx)).identifier().getLast())).createAndStore();
    }
}

