/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-thread-interleaving-on-concurrent-map-operations", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidThreadInterleavingOnConcurrentMapOperations
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid thread interleaving between read and update operations in `ConcurrentMap`";
    private static final String FINDING_MESSAGE = "Avoid thread interleaving between read and update operations in `ConcurrentMap`: {0}";
    private static final int RECEIVER_GROUP = 0;
    private static final TokenPattern READ_OPERATION_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOT}).alternative(new Object[]{TokenPattern.text((String)"containsKey"), TokenPattern.text((String)"get"), TokenPattern.text((String)"getOrDefault")}).sequence(new Object[]{ETokenType.LPAREN});
    private static final TokenPattern UPDATE_OPERATION_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOT}).alternative(new Object[]{TokenPattern.text((String)"put"), TokenPattern.text((String)"remove")}).sequence(new Object[]{ETokenType.LPAREN});
    private static final Set<String> CONCURRENT_MAP_TYPES = Set.of("ConcurrentMap", "ConcurrentHashMap", "ConcurrentNavigableMap", "ConcurrentSkipListMap");

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if ("lambda".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) throws CheckException {
        UnmodifiableList tokens = method.includedTokens();
        List readOperations = READ_OPERATION_PATTERN.findAll((List)tokens);
        if (readOperations.isEmpty()) {
            return;
        }
        List updateOperations = UPDATE_OPERATION_PATTERN.findAll((List)tokens);
        if (updateOperations.isEmpty()) {
            return;
        }
        Set<Pair<ShallowEntity, String>> readReceivers = this.getReceivers(method, readOperations);
        Set<Pair<ShallowEntity, String>> updatedReceivers = this.getReceivers(method, updateOperations);
        for (Pair receiver : Sets.intersection(readReceivers, updatedReceivers)) {
            ShallowEntity declaringEntity = (ShallowEntity)receiver.getFirst();
            String receiverVariable = (String)receiver.getSecond();
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE, receiverVariable), this.buildLocation().forEntity(declaringEntity)).createAndStore();
        }
    }

    private Set<Pair<ShallowEntity, String>> getReceivers(ShallowEntity method, List<TokenPatternMatch> operations) throws CheckException {
        HashSet<Pair<ShallowEntity, String>> receivers = new HashSet<Pair<ShallowEntity, String>>();
        for (TokenPatternMatch operation : operations) {
            IToken receiverToken = (IToken)Iterables.getOnlyElement((Iterable)operation.groupTokens(0));
            String receiver = receiverToken.getText();
            ShallowEntity entity = AvoidThreadInterleavingOnConcurrentMapOperations.findOwningEntity(method, receiverToken).orElseThrow(() -> new CheckException("Could not find shallow entity for " + receiver));
            ScopedTypeLookup types = this.context.getTypeResolution(this.getCodeViewOption()).getTypeLookup(entity);
            TypedVariable receiverType = types.getTypeInfo(receiver);
            if (receiverType == null || !CONCURRENT_MAP_TYPES.contains(receiverType.getTypeNameWithoutGenericTypeParameter())) continue;
            ShallowEntity declaringEntity = receiverType.getDeclaringEntity();
            receivers.add((Pair<ShallowEntity, String>)Pair.createPair((Object)declaringEntity, (Object)receiver));
        }
        return receivers;
    }

    private static Optional<ShallowEntity> findOwningEntity(ShallowEntity searchRoot, IToken token) {
        class ShallowEntityVisitor
        implements IShallowEntityVisitor {
            private ShallowEntity surroundingEntity;
            final /* synthetic */ IToken val$token;

            ShallowEntityVisitor(IToken iToken) {
                this.val$token = iToken;
            }

            public boolean visit(ShallowEntity entity) {
                if (entity.ownTokens().stream().anyMatch(tokens -> tokens.contains((Object)this.val$token))) {
                    this.surroundingEntity = entity;
                    return false;
                }
                return true;
            }
        }
        ShallowEntityVisitor visitor = new ShallowEntityVisitor(token);
        searchRoot.traverse((IShallowEntityVisitor)visitor);
        return Optional.ofNullable(visitor.surroundingEntity);
    }
}

