/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.nio.file.Paths;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-inconsistent-function-and-filename", languages={ELanguage.MATLAB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class InconsistentFunctionAndFilename
extends CheckImplementationBase {
    protected static final String CHECK_NAME = "The name of the first function defined in a file should be the same as the filename";

    public void execute() throws CheckException {
        IToken someToken;
        String uniformPath;
        String filename;
        String filenameWithoutExtension;
        UnmodifiableList entities = this.context.getRootEntity(this.getCodeViewOption()).getChildren();
        for (ShallowEntity entity : entities) {
            if (EShallowEntityType.TYPE != entity.getType() || !entity.getSubtype().equals("class")) continue;
            return;
        }
        List functions = this.select("//METHOD");
        if (functions.size() <= 0) {
            return;
        }
        ShallowEntity firstFunction = (ShallowEntity)functions.get(0);
        String functionName = firstFunction.getName();
        if (!functionName.equals(filenameWithoutExtension = StringUtils.removeLastPart((String)(filename = Paths.get(uniformPath = (someToken = (IToken)firstFunction.ownStartTokens().get(0)).getOriginId(), new String[0]).getFileName().toString()), (char)'.'))) {
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntityFirstLine(firstFunction)).createAndStore();
        }
    }
}

