/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.oscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-avoid-dynamic", languages={ELanguage.OSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidDynamicCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            if (!TokenStreamUtils.contains((List)selectedEntity.ownStartTokens(), (ETokenType)ETokenType.DYNAMIC) || TokenStreamUtils.contains((List)selectedEntity.ownStartTokens(), (ETokenType)ETokenType.OVERRIDE)) continue;
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        PairList<String, String> namesAndTypes = AvoidDynamicCheck.getNamesAndTypesOfDynamics(entity);
        for (Pair namesAndType : namesAndTypes) {
            String name = (String)namesAndType.getFirst();
            String type = (String)namesAndType.getSecond();
            String message = StringUtils.capitalize((String)type) + " \"" + name + "\" should not be `Dynamic`";
            if (type.equals("parameter")) {
                this.buildFinding(message, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
                continue;
            }
            this.buildFinding(message, this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private static PairList<String, String> getNamesAndTypesOfDynamics(ShallowEntity entity) {
        PairList namesAndTypes = new PairList();
        UnmodifiableList tokens = entity.ownStartTokens();
        if (entity.getType().equals((Object)EShallowEntityType.METHOD)) {
            int parenIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.LPAREN);
            AvoidDynamicCheck.addNamesFromTokens((PairList<String, String>)namesAndTypes, entity.getSubtype(), (List<IToken>)tokens, (Pair<Integer, Integer>)new Pair((Object)0, (Object)parenIndex));
            AvoidDynamicCheck.addNamesFromTokens((PairList<String, String>)namesAndTypes, "parameter", (List<IToken>)tokens, (Pair<Integer, Integer>)new Pair((Object)parenIndex, (Object)tokens.size()));
        } else {
            AvoidDynamicCheck.addNamesFromTokens((PairList<String, String>)namesAndTypes, entity.getSubtype(), (List<IToken>)tokens, (Pair<Integer, Integer>)new Pair((Object)0, (Object)tokens.size()));
        }
        return namesAndTypes;
    }

    private static void addNamesFromTokens(PairList<String, String> namesAndTypes, String type, List<IToken> tokens, Pair<Integer, Integer> limits) {
        List indices = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)((Integer)limits.getFirst()), (int)((Integer)limits.getSecond()), (ETokenType[])new ETokenType[]{ETokenType.DYNAMIC, ETokenType.IDENTIFIER});
        for (Integer index : indices) {
            namesAndTypes.add((Object)tokens.get(index + 1).getText(), (Object)type);
        }
    }
}

