/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.python.PythonMainMethodUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-avoid-print-call", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidPrintCallCheck
extends CheckImplementationBase {
    private static final TokenPattern PRINT_PATTERN = new TokenPattern().tokenText("print").group(0).alternative(new Object[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL, new TokenPattern().skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false)});
    @CheckOption(name="Allow print statements in main file", description="If this option is enabled, it is allowed to use print statements in files with the main method. This is useful for command line tools.")
    private boolean allowInMainFile = false;
    private boolean isMainFile = false;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        this.isMainFile = AvoidPrintCallCheck.determineIfMainFile(statements);
        for (ShallowEntity statement : statements) {
            this.processTokens((List<IToken>)statement.ownStartTokens());
            this.processTokens((List<IToken>)statement.ownEndTokens());
        }
    }

    private static boolean determineIfMainFile(List<ShallowEntity> statements) {
        for (ShallowEntity statement : statements) {
            if (!PythonMainMethodUtils.isMainMethod(statement)) continue;
            return true;
        }
        return false;
    }

    private void processTokens(List<IToken> tokens) {
        if (this.allowInMainFile && this.isMainFile) {
            return;
        }
        for (TokenPatternMatch match : PRINT_PATTERN.findAll(tokens)) {
            this.buildFinding("Do not use `print()`", this.buildLocation().forTokens(match.groupTokens(0))).createAndStore();
        }
    }
}

