/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

@Check(id="cqse-do-not-compare-none-with-operator", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotCompareNoneWithOperatorCheck
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> FORBIDDEN_OPERATORS = EnumSet.of(ETokenType.EQEQ, ETokenType.NOTEQ);
    private static final TokenPattern FINDING_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{FORBIDDEN_OPERATORS, ETokenType.NONE}), new TokenPattern().sequence(new Object[]{ETokenType.NONE, FORBIDDEN_OPERATORS})}).group(0);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processTokens((List<IToken>)statement.ownStartTokens());
            this.processTokens((List<IToken>)statement.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        for (TokenPatternMatch match : FINDING_PATTERN.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            String message = DoNotCompareNoneWithOperatorCheck.getFindingMessage(matchedTokens);
            this.buildFinding(message, this.buildLocation().forTokens(matchedTokens)).createAndStore();
        }
    }

    private static String getFindingMessage(List<IToken> tokens) {
        if (TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.EQEQ)) {
            return "`None` should not be compared with `==`, use `is` instead";
        }
        return "`None` should not be compared with `!=`, use `is not` instead";
    }
}

