/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility.python3;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.python.compatibility.ImportAwarePythonCompatibiltiyCheckBase;
import eu.cqse.check.python.compatibility.PythonImportAwareFindingsPattern;
import java.util.ArrayList;
import java.util.List;

@Check(id="cqse-builtin-methods-compatibility-python3", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class BuiltinMethodsCompatibilityPython3Check
extends ImportAwarePythonCompatibiltiyCheckBase {
    @Override
    protected List<PythonImportAwareFindingsPattern> getFindingPatterns() {
        ArrayList<PythonImportAwareFindingsPattern> patterns = new ArrayList<PythonImportAwareFindingsPattern>();
        patterns.add(new PythonImportAwareFindingsPattern(new TokenPattern().tokenText("isinstance").skipTo(new Object[]{ETokenType.COMMA}).tokenText("basestring").group(0), "past.builtins.basestring", "`basestring` is not available in Python 3"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createPattern("long", "past.builtins.long"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("xrange", "past.builtins.xrange"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("reduce", "functools.reduce"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("raw_input", null));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("file", null));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("execfile", "past.builtins.execfile"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("unichr", null));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("intern", "past.builtins.intern"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("apply", "past.builtins.apply"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("cmp", "past.builtins.cmp"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("reload", "imp.reload"));
        patterns.add(BuiltinMethodsCompatibilityPython3Check.createCallPattern("unicode", null));
        return patterns;
    }

    private static PythonImportAwareFindingsPattern createPattern(String builtIn, String allowedIfImported) {
        return new PythonImportAwareFindingsPattern(builtIn, allowedIfImported, "`" + builtIn + "` is not supported in Python 3");
    }

    private static PythonImportAwareFindingsPattern createCallPattern(String methodName, String allowedIfImported) {
        return new PythonImportAwareFindingsPattern(new TokenPattern().notPrecededBy((Object)ETokenType.DOT).tokenText(methodName).group(0).sequence(new Object[]{ETokenType.LPAREN}).notFollowedBy((Object)ETokenType.RPAREN).skipTo(new Object[]{ETokenType.RPAREN}).endOfStream(), allowedIfImported, "`" + methodName + "` is not available in Python 3");
    }
}

