/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.LinkedList;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.himl_0009", languages={ELanguage.SIMULINK, ELanguage.MATLAB}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkEqualAndNotEqualUsageCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)("Compare ranges using " + MarkupUtils.formatAsSourceCode((String)"<=") + " and " + MarkupUtils.formatAsSourceCode((String)">=") + "instead of equality operators."));
    private static final String FINDING_MESSAGE = "Floating-point operand(s) in the equality comparison between %s and %s in line %d";
    private static final String UNRESOLVABLE_DATA_TYPE_FINDING_MESSAGE_PATTERN = "The %s comparison operand in line %d must have an explicit non floating-point type. Avoid using \"Inherit: from definition in chart\".";
    private static final FindingPropertyList UNRESOLVABLE_DATA_TYPE_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider explicitly declaring the type of the operand.");

    public void execute() {
        QualifiedNameLocation location;
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedTypes == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            location = this.context.buildLocation().forSimulinkBlock(block);
            for (MatlabActionTypeResolver methodBody : SimulinkMatlabCheckUtils.parseMethodsInMatlabFunctionBlockAndLogParseErrors(block, resolvedTypes, dataDictionaries, location.getQualifiedName())) {
                this.checkMethodBody(methodBody, location, false);
            }
        }
        for (StateflowState matlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            location = this.context.buildLocation().forStateflowNode((StateflowNodeBase)matlabFunctionState);
            for (MatlabActionTypeResolver methodBody : SimulinkMatlabCheckUtils.parseMethodsInMatlabFunctionStateAndLogParseErrors(matlabFunctionState, resolvedTypes, dataDictionaries, location.getQualifiedName())) {
                this.checkMethodBody(methodBody, location, true);
            }
        }
    }

    private void checkMethodBody(MatlabActionTypeResolver typeResolver, QualifiedNameLocation findingLocation, boolean checksMatlabFunctionState) {
        for (MatlabActionAstNode comparisonNode : SimulinkEqualAndNotEqualUsageCheck.listEqualityNodes(typeResolver.getRootNode())) {
            MatlabActionAstNode leftNode = (MatlabActionAstNode)comparisonNode.getChildren().get(0);
            MatlabActionAstNode rightNode = (MatlabActionAstNode)comparisonNode.getChildren().get(1);
            String leftType = typeResolver.inferDataTypeOf(leftNode);
            String rightType = typeResolver.inferDataTypeOf(rightNode);
            if ("Unknown".equals(leftType)) {
                if (!checksMatlabFunctionState) continue;
                this.createFindingForUnresolvableDataType(findingLocation, leftNode, "left");
                continue;
            }
            if ("Unknown".equals(rightType)) {
                if (!checksMatlabFunctionState) continue;
                this.createFindingForUnresolvableDataType(findingLocation, rightNode, "right");
                continue;
            }
            if (!SimulinkDataTypeUtils.isFloatingPointDataType((String)leftType) && !SimulinkDataTypeUtils.isFloatingPointDataType((String)rightType)) continue;
            String leftNodeString = TokenStreamTextUtils.concatTokenTexts((List)leftNode.getTokens());
            String rightNodeString = TokenStreamTextUtils.concatTokenTexts((List)rightNode.getTokens());
            String findingMessage = String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)leftNodeString), MarkupUtils.formatAsSourceCode((String)rightNodeString), MatlabActionAstUtils.getLineNumberForAstNode((MatlabActionAstNode)leftNode));
            this.buildFinding(findingMessage, (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void createFindingForUnresolvableDataType(QualifiedNameLocation findingLocation, MatlabActionAstNode node, String side) {
        int lineNumber = MatlabActionAstUtils.getLineNumberForAstNode((MatlabActionAstNode)node);
        String findingMessage = String.format(UNRESOLVABLE_DATA_TYPE_FINDING_MESSAGE_PATTERN, side, lineNumber);
        this.buildFinding(findingMessage, (ElementLocation)findingLocation).addFindingProperties(UNRESOLVABLE_DATA_TYPE_RECOMMENDED_ACTION).createAndStore();
    }

    private static List<MatlabActionAstNode> listEqualityNodes(MatlabActionAstNode rootNode) {
        LinkedList<MatlabActionAstNode> equalityNodes = new LinkedList<MatlabActionAstNode>();
        SimulinkEqualAndNotEqualUsageCheck.listEqualityNodesRecursively(rootNode, equalityNodes);
        return equalityNodes;
    }

    private static void listEqualityNodesRecursively(MatlabActionAstNode node, List<MatlabActionAstNode> equalityNodes) {
        if (SimulinkEqualAndNotEqualUsageCheck.isEqualOrNotEqualOperator(node)) {
            equalityNodes.add(node);
        }
        node.getChildren().forEach(child -> SimulinkEqualAndNotEqualUsageCheck.listEqualityNodesRecursively(child, equalityNodes));
    }

    private static boolean isEqualOrNotEqualOperator(MatlabActionAstNode node) {
        return EMatlabActionEntityType.COMPARISON == node.getType() && node.getTokens().stream().anyMatch(token -> token.getText().equals("~=") || token.getText().equals("=="));
    }
}

