/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.simulink.naming_conventions.SimulinkNameLengthCheckUtils;
import eu.cqse.check.simulink.naming_conventions.SimulinkUsableCharactersForParameterNamesCheck;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0246", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkParameterNameLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum length of parameter names", description="The maximum number of characters for names of parameters.")
    private int maximumLength = 60;

    public void execute() {
        this.context.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile().ifPresent(this::checkDataDictionary);
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkModel);
    }

    private void checkDataDictionary(SimulinkDataDictionary dataDictionary) {
        List parameters = dataDictionary.getEntries().stream().filter(entry -> entry instanceof SimulinkParameter).collect(Collectors.toList());
        for (ISimulinkDataDictionaryEntry parameter : parameters) {
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, parameter.getName(), parameter.getEntryType(), this.buildLocation().forSimulinkDataDictionaryEntry(parameter));
        }
    }

    private void checkModel(SimulinkModel model) {
        HashSet<String> parameterNamesInModelWorkspace = new HashSet<String>(SimulinkUtils.getSimulinkParameterNames((SimulinkModel)model));
        HashSet<String> parameterNamesCheckedOnBlocks = new HashSet<String>();
        Set parameterNamesInDictionaries = SimulinkUtils.getAllNamesOfDictionaryType(new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class)), SimulinkParameter.class);
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            List<IToken> extractedIdentifierTokens = SimulinkUsableCharactersForParameterNamesCheck.getIdentifiersFromParameterValueExpression(block, this.context.getUniformPath());
            for (IToken token : extractedIdentifierTokens) {
                String parameterName = token.getText();
                if (parameterNamesInDictionaries.contains(parameterName)) continue;
                parameterNamesCheckedOnBlocks.add(parameterName);
                String parameterOrigin = SimulinkUsableCharactersForParameterNamesCheck.getParameterOrigin(parameterName, parameterNamesInModelWorkspace);
                SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, parameterName, "Simulink.Parameter" + parameterOrigin, this.buildLocation().forSimulinkBlock(block));
            }
        }
        for (String parameterName : CollectionUtils.differenceSet(parameterNamesInModelWorkspace, (Collection[])new Collection[]{parameterNamesCheckedOnBlocks})) {
            String parameterOrigin = SimulinkUsableCharactersForParameterNamesCheck.getParameterOrigin(parameterName, parameterNamesInModelWorkspace);
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, parameterName, "Simulink.Parameter" + parameterOrigin, this.buildLocation().forSimulinkBlock((SimulinkBlock)model));
        }
    }
}

