/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.ENumericDataType;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0017", languages={ELanguage.SIMULINK})
public class SimulinkBlocksComputeRelationalOperatorCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_TYPE_BOOL = "Block that computes relational operators does not have output data type 'Boolean'";
    private static final String FINDING_MESSAGE_SAME_TYPES = "Relational Operator block has multiple input data types";
    private static final FindingPropertyList RECOMMENDED_ACTION_TYPE_BOOL = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change output signal data type to 'Boolean'");
    private static final FindingPropertyList RECOMMENDED_ACTION_SAME_TYPES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set all input signals of the block to the same data type");
    private static final Set<String> RELATIONAL_OPERATOR_BLOCK_TYPES = Set.of("RelationalOperator", "Compare To Zero", "Compare To Constant", "Detect Change");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes dataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || dataTypes == null) {
            return;
        }
        SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false).stream().filter(SimulinkBlocksComputeRelationalOperatorCheck::computesRelationalOperator).filter(block -> !SimulinkBlocksComputeRelationalOperatorCheck.hasBooleanOutputType(block)).forEach(block -> this.buildFinding(FINDING_MESSAGE_TYPE_BOOL, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_TYPE_BOOL).createAndStore());
        SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("RelationalOperator"), (boolean)false, (boolean)false).stream().filter(block -> SimulinkBlocksComputeRelationalOperatorCheck.hasMoreThanOneInputDataType(block, dataTypes)).forEach(block -> this.buildFinding(FINDING_MESSAGE_SAME_TYPES, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SAME_TYPES).createAndStore());
    }

    private static boolean hasBooleanOutputType(SimulinkBlock block) {
        String outputDataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (outputDataType == null) {
            return false;
        }
        if (outputDataType.startsWith("fixdt")) {
            return "boolean".equals(SimulinkDataTypeUtils.getRealDataTypeOfFixedDataType((String)outputDataType, (boolean)false));
        }
        ENumericDataType enumDataType = (ENumericDataType)EnumUtils.valueOfIgnoreCase(ENumericDataType.class, (String)outputDataType);
        return enumDataType == null || ENumericDataType.BOOLEAN == enumDataType;
    }

    private static boolean computesRelationalOperator(SimulinkBlock block) {
        if (RELATIONAL_OPERATOR_BLOCK_TYPES.contains(block.getType())) {
            return true;
        }
        String sourceType = block.getSourceType();
        return sourceType != null && RELATIONAL_OPERATOR_BLOCK_TYPES.contains(sourceType);
    }

    private static boolean hasMoreThanOneInputDataType(SimulinkBlock block, SimulinkResolvedDataTypes dataTypes) {
        HashSet inputDataTypes = new HashSet(dataTypes.getInputDataTypes(block));
        inputDataTypes.remove("Unknown");
        inputDataTypes.remove("NOT_CONNECTED");
        return inputDataTypes.size() > 1;
    }
}

