/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkDataStorage;
import org.conqat.lib.simulink.model.SimulinkModel;

@Check(id="cqse.jmaab.jc_0791", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkDuplicationOfDataNamesCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Duplicate data name %s in data dictionary and model workspace";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Rename the duplicate data name either in the data dictionary or the model workspace.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        List<SimulinkDataDictionary> dictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        if (model == null || dictionaries.isEmpty()) {
            return;
        }
        this.checkDuplicatesBetweenModelWorkspaceAndDictionaries(model, dictionaries);
    }

    private void checkDuplicatesBetweenModelWorkspaceAndDictionaries(SimulinkModel model, List<SimulinkDataDictionary> dictionaries) {
        List<String> dictionaryNames = SimulinkDuplicationOfDataNamesCheck.getDictionaryEntryNames(dictionaries);
        Set modelWorkspaceNames = model.modelWorkspace.getEntryNames();
        HashSet duplicates = CollectionUtils.intersectionSet(dictionaryNames, (Collection[])new Collection[]{modelWorkspaceNames});
        for (String duplicate : duplicates) {
            String message = String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)duplicate));
            this.buildFinding(message, this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static List<String> getDictionaryEntryNames(List<SimulinkDataDictionary> dictionaries) {
        return dictionaries.stream().map(SimulinkDataStorage::getEntries).flatMap(Collection::stream).map(ISimulinkDataDictionaryEntry::getName).collect(Collectors.toList());
    }
}

