/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.db_0110", languages={ELanguage.SIMULINK})
public class SimulinkEnsureBlockParametersAreTunableCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Move the calculation outside the block. For example, perform it in a series of Simulink blocks or precompute it as a new variable.");
    private static final TokenPattern FIELD_ACCESS_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER});
    private static final Map<String, List<String>> RELEVANT_PARAMETERS_PER_TARGET_BLOCK = new HashMap<String, List<String>>();

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        Set<String> allMatlabFunctionNames = SimulinkNameChecker.MATLAB_FUNCTION_NAMES;
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, RELEVANT_PARAMETERS_PER_TARGET_BLOCK.keySet(), (boolean)false, (boolean)false)) {
            for (String relevantParameterName : RELEVANT_PARAMETERS_PER_TARGET_BLOCK.get(block.getType())) {
                String parameterValue = block.getParameter(relevantParameterName);
                if (parameterValue == null) continue;
                List tokens = TokenStreamUtils.removeAtEnd((List)ScannerUtils.getTokens((String)parameterValue, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath()), (ETokenType)ETokenType.EOL);
                if ((tokens = CollectionUtils.filter((Collection)tokens, token -> !allMatlabFunctionNames.contains(token.getText()))).size() == 1 || !TokenStreamUtils.contains((List)tokens, (ETokenType)ETokenType.IDENTIFIER) || FIELD_ACCESS_PATTERN.matchFully(tokens) != null) continue;
                this.buildFinding("Block parameter " + MarkupUtils.formatAsSourceCode((String)relevantParameterName) + " must be tunable", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    static {
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Relay", List.of("OnSwitchValue", "OffOutputValue", "OnOutputValue", "OffSwitchValue"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("StateSpace", List.of("A", "B", "C", "D", "InitialCondition", "AbsoluteTolerance"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Memory", List.of("InitialCondition", "StateName"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Constant", List.of("Value"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Bias", List.of("Bias"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("HitCross", List.of("HitCrossingOffset"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("InitialCondition", List.of("Value"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Reference", List.of("OutputWordLength", "NumDataPoints", "const"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("TransportDelay", List.of("InitialOutput", "PadeOrder", "DelayTime", "BufferSize"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Quantizer", List.of("QuantizationInterval"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Integrator", List.of("InitialCondition", "AbsoluteTolerance"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("RateLimiter", List.of("InitialCondition", "FallingSlewLimit", "RisingSlewLimit"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Saturate", List.of("UpperLimit", "LowerLimit"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("UnitDelay", List.of("InitialCondition", "SampleTime"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("RealImagToComplex", List.of("ConstantPart"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Backlash", List.of("BacklashWidth"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("PermuteDimensions", List.of("Order"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Lookup_n-D", Arrays.asList("BreakpointsForDimension1", "BreakpointsForDimension2", "BreakpointsForDimension3", "Table"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Switch", List.of("Threshold"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("DiscreteIntegrator", List.of("InitialCondition", "LowerSaturationLimit", "gainval", "UpperSaturationLimit", "SampleTime"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Derivative", List.of("CoefficientInTFapproximation"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("DeadZone", List.of("UpperValue", "LowerValue"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("Gain", List.of("Gain"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("CombinatorialLogic", List.of("TruthTable"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("RateTransition", List.of("InitialCondition", "OutPortSampleTime"));
        RELEVANT_PARAMETERS_PER_TARGET_BLOCK.put("VariableTransportDelay", List.of("InitialOutput", "PadeOrder", "MaximumPoints", "AbsoluteTolerance", "MaximumDelay"));
    }
}

