/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0626", languages={ELanguage.SIMULINK})
public class SimulinkLookupTableBlockParametersCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_LOOKUP_TABLE_DYNAMIC = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the Lookup Table Dynamic block's parameter 'Lookup Method' to 'Interpolation - Use end Values'.");
    private static final FindingPropertyList RECOMMENDED_ACTION_LOOKUP_TABLE_ND_INTERPOLATION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the n-D Lookup Table block's parameter 'Interpolation Method' to 'Linear point-slope' or 'Linear Lagrange'.");
    private static final FindingPropertyList RECOMMENDED_ACTION_LOOKUP_TABLE_ND_EXTRAPOLATION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the n-D Lookup Table block's parameter 'Extrapolation Method' to 'Clip'.");
    private static final FindingPropertyList RECOMMENDED_ACTION_LOOKUP_TABLE_ND_USE_LAST_TABLE_VALUE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Select the n-D Lookup Table block's parameter 'Use last table value for inputs at or above last breakpoint'.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String typeOrSourceType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
            if ("Lookup Table Dynamic".equals(typeOrSourceType)) {
                this.checkParameter(block, "Lookup Table Dynamic block", "LookUpMeth", Set.of("Interpolation-Use End Values"), "Lookup method", RECOMMENDED_ACTION_LOOKUP_TABLE_DYNAMIC);
                continue;
            }
            if (!"Lookup_n-D".equals(typeOrSourceType)) continue;
            this.checkParameter(block, "n-D Lookup Table block", "InterpMethod", Set.of("Linear point-slope", "Linear Lagrange"), "Interpolation method", RECOMMENDED_ACTION_LOOKUP_TABLE_ND_INTERPOLATION);
            this.checkParameter(block, "n-D Lookup Table block", "ExtrapMethod", Set.of("Clip"), "Extrapolation method", RECOMMENDED_ACTION_LOOKUP_TABLE_ND_EXTRAPOLATION);
            this.checkParameter(block, "n-D Lookup Table block", "UseLastTableValue", Set.of("on"), "Use last table value for inputs at or above last breakpoint", RECOMMENDED_ACTION_LOOKUP_TABLE_ND_USE_LAST_TABLE_VALUE);
        }
    }

    private void checkParameter(SimulinkBlock block, String blockTypeReadable, String parameter, Set<String> acceptedValues, String paramReadableName, FindingPropertyList recommendedAction) {
        String parameterValue = block.getParameter(parameter);
        if (StringUtils.isEmpty((String)parameterValue)) {
            return;
        }
        if (!acceptedValues.contains(parameterValue)) {
            this.buildFinding(blockTypeReadable + " parameter " + MarkupUtils.formatAsSourceCode((String)paramReadableName) + " is set to " + MarkupUtils.formatAsSourceCode((String)parameterValue), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(recommendedAction).createAndStore();
        }
    }
}

