/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0630", languages={ELanguage.SIMULINK})
public class SimulinkMultiportSwitchDataPortsCheck
extends CheckImplementationBase {
    @CheckOption(name="Multiport Switch block - Force at least two data ports (jc_0630_a)", description="If set, Multiport Switch blocks shall have at least 2 data ports.")
    private boolean forceAtLeastTwoDataPorts = true;
    @CheckOption(name="Multiport Switch block - Force unsigned integer type as control input (jc_0630_b)", description="If set, Multiport Switch blocks shall have an unsigned integer type as input to the control-input port.")
    private boolean forceUnsignedIntControlInputType = true;
    @CheckOption(name="Multiport Switch block - Check data port order (jc_0630_c)", description="If set, Multiport Switch blocks shall have the following configuration if parameter *Data port order* is set to 'Specify indices':\n  - parameter *Data port for default case* shall be set to 'Additional data port',\n  - parameter *Diagnostic for default case* shall be set to 'None'.")
    private boolean forceDataPortOrder = true;
    private static final FindingPropertyList RECOMMENDED_ACTION_ONLY_ONE_DATA_PORT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Ensure that the Multiport Switch block has at least two data ports.");
    private static final FindingPropertyList RECOMMENDED_ACTION_INVALID_DATA_PORT_ORDER = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set parameter 'Data port for default case' to 'Additional data port' and parameter 'Diagnostics for default case' to 'None' for the Multiport Switch block.");
    private static final String CONTROL_INPUT_FINDING = "Multiport Switch block has a control input of type %s (requires an unsigned int)";
    private static final FindingPropertyList CONTROL_INPUT_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use an unsigned integer type as control input to the switch block.");

    public void execute() {
        if (!(this.forceAtLeastTwoDataPorts || this.forceDataPortOrder || this.forceUnsignedIntControlInputType)) {
            return;
        }
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        Optional signalTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile();
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("MultiPortSwitch"), (boolean)false, (boolean)false)) {
            if (this.forceAtLeastTwoDataPorts) {
                this.checkNumberOfDataPorts(block);
            }
            if (this.forceUnsignedIntControlInputType && signalTypes.isPresent()) {
                this.checkControlInputType(block, (SimulinkResolvedDataTypes)signalTypes.get());
            }
            if (!this.forceDataPortOrder) continue;
            this.checkDataPortOrder(block);
        }
    }

    private void checkNumberOfDataPorts(SimulinkBlock block) {
        long numberOfInports = block.getInPorts().stream().filter(port -> port.getPortType() == SimulinkPortBuilder.EPortType.INPORT).count();
        if (numberOfInports <= 2L) {
            this.buildFinding("Multiport Switch block has less than two data ports", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_ONLY_ONE_DATA_PORT).createAndStore();
        }
    }

    private void checkControlInputType(SimulinkBlock block, SimulinkResolvedDataTypes signalTypes) {
        String controlPortInputDataType = signalTypes.getInputDataType(block, SimulinkDataTypeUtils.getInputControlPortNumber((SimulinkBlock)block));
        if (controlPortInputDataType == null || controlPortInputDataType.isEmpty() || controlPortInputDataType.equals("Unknown") || controlPortInputDataType.equals("NOT_CONNECTED")) {
            return;
        }
        if (!SimulinkDataTypeUtils.isUnsignedIntDataType((String)controlPortInputDataType)) {
            this.context.buildFinding(String.format(CONTROL_INPUT_FINDING, MarkupUtils.formatAsSourceCode((String)controlPortInputDataType)), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(CONTROL_INPUT_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkDataPortOrder(SimulinkBlock block) {
        if (!"Specify indices".equals(block.getParameter("DataPortOrder"))) {
            return;
        }
        if (!"Additional data port".equals(block.getParameter("DataPortForDefault")) || !"None".equals(block.getParameter("DiagnosticForDefault"))) {
            this.buildFinding("Multiport Switch block has invalid data port order configuration", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_INVALID_DATA_PORT_ORDER).createAndStore();
        }
    }
}

