/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0007", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfForOrWhileIteratorSubsystems
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove time-dependent block from For or While Iterator subsystems.");
    @CheckOption(name="Block/source types of sample time-dependent blocks", description="A list of all the sample time-dependent block types or, if the block type is `Reference`, the source type. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> sampleTimeDependentBlockAndSourceTypes = CollectionUtils.asHashSet((Object[])new String[]{"DiscreteStateSpace", "DiscreteIntegrator", "DiscreteFir", "DiscreteFilter", "DiscreteTransferFcn", "DiscreteZeroPole", "First Order Transfer Fcn", "Transfer Fcn Real Zero", "Lead or Lag Compensator", "Discrete Transfer Function with Initial Outputs", "Discrete Transfer Function with Initial States", "Discrete Zero-Pole with Initial Outputs", "Discrete Zero-Pole with Initial States", "Discrete Derivative"});

    public void execute() {
        Optional model = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (model.isEmpty()) {
            return;
        }
        SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)((SimulinkBlock)model.get()), (boolean)false, (boolean)false).stream().filter(SimulinkUtils::isForOrWhileIteratorSubsystem).forEach(this::findSampleTimeDependentBlocks);
    }

    private void findSampleTimeDependentBlocks(SimulinkBlock block) {
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            if (SimulinkUtils.isCommentedBlock((SimulinkBlock)subBlock) || !this.isSampleTimeDependentBlock(subBlock)) continue;
            this.buildFinding("Block of type " + subBlock.getResolvedType() + " shall not be used in a For or While Iterator Subsystem", (ElementLocation)this.buildLocation().forSimulinkBlock(subBlock)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private boolean isSampleTimeDependentBlock(SimulinkBlock block) {
        String typeOrSourceType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
        return typeOrSourceType != null && this.sampleTimeDependentBlockAndSourceTypes.contains(typeOrSourceType);
    }
}

