/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.utils;

import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.builder.SimulinkConfigSet;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class ExternalConfigSetUtils {
    public static Optional<String> getParameter(@Nullable SimulinkModel model, @Nullable SimulinkConfigSet configSet, String parameterName) {
        if (model != null && model.getParameter(parameterName) != null) {
            return Optional.of(model.getParameter(parameterName));
        }
        if (configSet != null && configSet.getParameter(parameterName) != null) {
            return Optional.of(configSet.getParameter(parameterName));
        }
        return Optional.empty();
    }

    public static Optional<SimulinkConfigSet> getExternalConfigSet(SimulinkModel model, ICheckContext context) {
        String name = model.getExternalConfigSetName().orElse(null);
        if (name == null) {
            return Optional.empty();
        }
        List<SimulinkDataDictionary> dictionaries = new SimulinkCheckFileReferencesResolver(context).getSimulinkDataDictionariesForModel(model, context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        return SimulinkUtils.findDataDictionaryEntry(dictionaries, (String)name, SimulinkConfigSet.class);
    }

    private ExternalConfigSetUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

