/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.swift;

import eu.cqse.check.clike.ConditionalStatementsEqualCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.clike.ConditionalBlock;
import java.util.List;

@Check(id="cqse-conditional-statements-equal-swift", languages={ELanguage.SWIFT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SwiftConditionalStatementsEqualCheck
extends ConditionalStatementsEqualCheckBase {
    public static final String NAME = "Statements in Conditional Expression are equal (Swift)";
    @CheckOption(name="Statements in Conditional Expression are equal (Swift): Flag one line conditions as duplicate", description="If enabled, conditional branch bodies that contain only a single line of code are included in the equality check. If disabled, these one-line branch bodies are excluded from the equality check.")
    private boolean flagOneLiners = false;
    @CheckOption(name="Statements in Conditional Expression are equal (Swift): Use character equality.", description="If enabled, character equality is used to compare the statements within the conditional branches; findings are created only if the statements are exactly the same on the character level. If disabled, the statements within the conditional branches are compared on the token level, i.e., findings are created for conditional branches that are likely to be similar in meaning, but differ in their concrete text contents.")
    private boolean useCharacterEquality = true;

    @Override
    protected boolean useCharacterEquality() {
        return this.useCharacterEquality;
    }

    @Override
    protected boolean shouldSkipBlock(ConditionalBlock block, List<IToken> slocTokens, int sloc) {
        List condition = block.getCondition();
        boolean isLetCondition = condition.stream().anyMatch(t -> t.getType() == ETokenType.LET);
        boolean isOneLiner = !this.flagOneLiners && sloc == 1;
        return isLetCondition || isOneLiner;
    }

    @Override
    protected void prepareBlockGroupsProcessing() {
    }

    @Override
    protected int hashBlockContent(ConditionalBlock block) {
        return this.hashBlockContentForUnpreprocessedLanguages(block);
    }
}

