/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.VisibleForTesting;

public class HttpRedirectInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final String TRUSTED_REDIRECTS_PROPERTY_NAME = "com.teamscale.allowed-redirect-urls";
    private final List<String> allowedRedirects = HttpRedirectInterceptor.readDefaultAllowedRedirects();
    @VisibleForTesting
    public static final String LOCATION_HEADER = "Location";
    private final boolean disableRedirectsForPost;

    public HttpRedirectInterceptor() {
        this(false);
    }

    public HttpRedirectInterceptor(boolean disableRedirectsForPost) {
        this.disableRedirectsForPost = disableRedirectsForPost;
    }

    private static List<String> readDefaultAllowedRedirects() {
        String allowedRedirectsProperty = System.getProperty(TRUSTED_REDIRECTS_PROPERTY_NAME);
        if (allowedRedirectsProperty == null) {
            return Collections.emptyList();
        }
        return StringUtils.splitToList((String)allowedRedirectsProperty, (String)",");
    }

    public @NonNull Response intercept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (!response.isRedirect()) {
            return response;
        }
        if (this.disableRedirectsForPost && chain.request().method().equalsIgnoreCase("POST")) {
            return response;
        }
        Request redirectedRequest = this.createRedirectedRequest(chain, response);
        if (redirectedRequest == null) {
            return response;
        }
        response.close();
        return chain.proceed(redirectedRequest);
    }

    private @Nullable Request createRedirectedRequest(Interceptor.Chain chain, Response response) {
        LOGGER.traceEntry("Intercepting redirect response for request '{}'.", new Object[]{chain.request().url()});
        String locationHeader = response.header(LOCATION_HEADER);
        if (locationHeader == null) {
            LOGGER.debug("Location header not found.");
            return (Request)LOGGER.traceExit("Did not follow redirect", null);
        }
        HttpUrl url = response.request().url().resolve(locationHeader);
        if (url == null) {
            LOGGER.debug("Redirect {} -> {} was not followed, because the protocol is not supported.", new Supplier[]{() -> chain.request().url(), () -> response.request().url()});
            return (Request)LOGGER.traceExit("Did not follow redirect.", null);
        }
        if (this.isAllowedRedirect(url)) {
            return (Request)LOGGER.traceExit("Followed redirect.", (Object)chain.request().newBuilder().url(url.url()).build());
        }
        if (!url.scheme().equals(response.request().url().scheme())) {
            LOGGER.debug("Redirect {} -> {} was not followed, because it switched protocols.", new Supplier[]{() -> chain.request().url(), () -> response.request().url()});
            return (Request)LOGGER.traceExit("Did not follow redirect.", null);
        }
        Request.Builder redirectedRequestBuilder = chain.request().newBuilder().url(url.url());
        if (!HttpRedirectInterceptor.canReuseConnectionFor(response.request().url(), url)) {
            LOGGER.debug("Redirect {} -> {}: Omitting authorization to not leak credentials.", new Supplier[]{() -> chain.request().url(), () -> response.request().url()});
            redirectedRequestBuilder.removeHeader("Authorization");
        }
        LOGGER.debug("Following redirect {} -> {}.", new Supplier[]{() -> chain.request().url(), () -> response.request().url()});
        return (Request)LOGGER.traceExit("Followed redirect.", (Object)redirectedRequestBuilder.build());
    }

    private boolean isAllowedRedirect(HttpUrl url) {
        return this.allowedRedirects.stream().anyMatch(allowedUrl -> HttpRedirectInterceptor.canReuseConnectionFor(url, HttpUrl.parse((String)allowedUrl)));
    }

    @Contract(value="null,_ -> false; _, null -> false")
    private static boolean canReuseConnectionFor(@Nullable HttpUrl url, @Nullable HttpUrl other) {
        if (url == null || other == null) {
            return false;
        }
        return url.host().equals(other.host()) && url.port() == other.port() && url.scheme().equals(other.scheme());
    }

    @VisibleForTesting
    List<String> getAllowedRedirects() {
        return this.allowedRedirects;
    }
}

