/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.query.error.ExpectedTypeNotFoundException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.index.keyed.query.parser.PartialQueryExpression;
import org.conqat.engine.persistence.index.keyed.query.tree.AttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.MapAccessorOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.MaxFunction;
import org.conqat.engine.persistence.index.keyed.query.tree.MinFunction;
import org.conqat.engine.persistence.index.keyed.query.tree.NumericAggregationFunctionBase;
import org.conqat.engine.persistence.index.keyed.query.tree.SizeFunction;

public class PartialQueryExpressionParser {
    public static PartialQueryExpression parseLeftSideOfExpression(List<QueryToken> tokens) throws QueryParsingException {
        boolean isFunctionCall;
        PartialQueryExpressionParser.expectNumberOfTokens(tokens, 1);
        QueryToken identifierToken = tokens.get(0);
        String identifier = identifierToken.getText();
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.LITERAL, identifierToken);
        boolean bl = isFunctionCall = tokens.size() >= 4 && tokens.get(1).getType() == EQueryTokenType.PAREN_OPEN;
        if (isFunctionCall) {
            switch (identifier) {
                case "min": {
                    return PartialQueryExpressionParser.parseAggregationAccessor(MinFunction::new, tokens);
                }
                case "max": {
                    return PartialQueryExpressionParser.parseAggregationAccessor(MaxFunction::new, tokens);
                }
                case "size": {
                    return PartialQueryExpressionParser.parseAggregationAccessor(SizeFunction::new, tokens);
                }
            }
            return PartialQueryExpressionParser.parseMapAccessor(identifier, tokens);
        }
        return new PartialQueryExpression(new AttributeOperand(identifier), tokens.subList(1, tokens.size()));
    }

    private static PartialQueryExpression parseAggregationAccessor(Function<IAttributeOperand, NumericAggregationFunctionBase> operandGenerator, List<QueryToken> tokens) throws QueryParsingException {
        PartialQueryExpression attributeOperandAndRemainingTokens = PartialQueryExpressionParser.parseLeftSideOfExpression(tokens.subList(2, tokens.size()));
        List<QueryToken> remainingTokens = attributeOperandAndRemainingTokens.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remainingTokens, 1);
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.PAREN_CLOSE, remainingTokens.get(0));
        return new PartialQueryExpression(operandGenerator.apply(attributeOperandAndRemainingTokens.getOperand()), remainingTokens.subList(1, remainingTokens.size()));
    }

    private static PartialQueryExpression parseMapAccessor(String identifier, List<QueryToken> tokens) throws QueryParsingException {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 2;
        while (tokens.get(i).getType() != EQueryTokenType.PAREN_CLOSE) {
            PartialQueryExpressionParser.expectNumberOfTokens(tokens, 2);
            QueryToken argumentToken = tokens.get(i);
            PartialQueryExpressionParser.expectTokenType(EQueryTokenType.LITERAL, argumentToken);
            arguments.add(argumentToken.getText());
            if (tokens.get(++i).getType() == EQueryTokenType.PAREN_CLOSE) break;
            PartialQueryExpressionParser.expectTokenType(EQueryTokenType.COMMA, tokens.get(i));
            ++i;
        }
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.PAREN_CLOSE, tokens.get(i));
        return new PartialQueryExpression(new MapAccessorOperand(identifier, arguments), tokens.subList(i + 1, tokens.size()));
    }

    static void expectTokenType(EQueryTokenType expectedType, QueryToken actualToken) throws ExpectedTypeNotFoundException {
        if (actualToken.getType() != expectedType) {
            throw new ExpectedTypeNotFoundException(expectedType, actualToken);
        }
    }

    static void expectTokenType(Set<EQueryTokenType> expectedTypes, QueryToken actualToken) throws ExpectedTypeNotFoundException {
        if (!expectedTypes.contains((Object)actualToken.getType())) {
            throw new ExpectedTypeNotFoundException(expectedTypes, actualToken);
        }
    }

    static void expectNumberOfTokens(List<QueryToken> tokens, int size) throws QueryParsingException {
        if (tokens.size() < size) {
            throw new QueryParsingException("Expected a valid expression (e.g Status=Open), but did not receive a proper query. (Arguments needed: " + size + ", actual: " + tokens.size() + ").", tokens);
        }
    }
}

