/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.query.engine.DelegatingCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;

public class NotQuery
implements IQuery {
    private final IQuery query;

    public NotQuery(IQuery query) {
        this.query = query;
    }

    public String toString() {
        return "!(" + String.valueOf(this.query) + ")";
    }

    @Override
    public <T> Predicate<T> compile(ICompilationContext<T> context) throws QueryCompilationException {
        if (this.query instanceof NotQuery) {
            return ((NotQuery)this.query).query.compile(context);
        }
        return this.query.compile(new ComparisonValueMaskingCompilationContext<T>(context)).negate();
    }

    private static final class ComparisonValueMaskingCompilationContext<T>
    extends DelegatingCompilationContext<T> {
        private ComparisonValueMaskingCompilationContext(ICompilationContext<T> delegateContext) {
            super(delegateContext);
        }

        @Override
        public Predicate<T> getAttributeEqualsIgnoreCasePredicate(String attribute, String comparisonValue, boolean lenient) throws QueryCompilationException {
            return this.getAttributeAccessor(attribute).andThen(IAttributeOperand.stringComparer(comparisonValue, lenient)::test)::apply;
        }
    }
}

