/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.trend;

import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class SpecItemTrendItem {
    private final UnmodifiableList<TeamscaleIssueId> specItems;
    private final int testReferencesCount;
    private final int testedItemsCount;
    private final int productionCodeReferencesCount;
    private final int productionItemsCount;

    public SpecItemTrendItem(Collection<TeamscaleIssueId> specItems, int testReferencesCount, int testedItemsCount, int productionCodeReferencesCount, int productionItemsCount) {
        this.specItems = CollectionUtils.asUnmodifiable(new ArrayList<TeamscaleIssueId>(specItems));
        this.testReferencesCount = testReferencesCount;
        this.testedItemsCount = testedItemsCount;
        this.productionCodeReferencesCount = productionCodeReferencesCount;
        this.productionItemsCount = productionItemsCount;
    }

    public UnmodifiableList<TeamscaleIssueId> getSpecItems() {
        return this.specItems;
    }

    public int getSpecItemCount() {
        return this.specItems.size();
    }

    public int getTestReferencesCount() {
        return this.testReferencesCount;
    }

    public int getTestedItemsCount() {
        return this.testedItemsCount;
    }

    public int getProductionItemsCount() {
        return this.productionItemsCount;
    }

    public int getProductionCodeReferencesCount() {
        return this.productionCodeReferencesCount;
    }

    public String toString() {
        return Stream.of(this.specItems.size(), this.testReferencesCount, this.testedItemsCount, this.productionCodeReferencesCount, this.productionItemsCount).map(String::valueOf).collect(Collectors.joining(", ", "{", "}"));
    }
}

