/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store;

import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemBase;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ParentedStorageSystem
extends DelegatingStorageSystemBase {
    private final IStorageSystem parentStorageSystem;
    private final IndexSchema indexSchema;

    public ParentedStorageSystem(IStorageSystem storageSystem, IStorageSystem parentStorageSystem, IndexSchema indexSchema) {
        super(storageSystem);
        CCSMAssert.isNotNull((Object)parentStorageSystem, (String)"Parent storage system can't be null for parented storage system.");
        this.parentStorageSystem = parentStorageSystem;
        this.indexSchema = indexSchema;
    }

    @Override
    public IStore openStore(String name) throws StorageException {
        if (this.indexSchema.getEntry(name).getStorageOptions().contains((Object)EStorageOption.CROSS_PROJECT_MOUNTABLE)) {
            return this.parentStorageSystem.openStore(name);
        }
        return super.openStore(name);
    }

    @Override
    public void removeStore(String storeName) {
        throw new UnsupportedOperationException();
    }
}

