/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store;

import java.util.Optional;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.util.PartitionedStorageSystem;

public class PartitionedStorageSystemProvider
implements IStorageSystemProvider {
    private final PartitionedStorageSystem partitionedStorage;
    private final IStorageSystem underlyingStorage;

    public PartitionedStorageSystemProvider(IStorageSystem storageSystem) {
        this.underlyingStorage = storageSystem;
        this.partitionedStorage = new PartitionedStorageSystem(storageSystem);
    }

    @Override
    public void removeStorageSystem(String partitionName) throws StorageException {
        this.partitionedStorage.removePartition(partitionName);
    }

    @Override
    public IStorageSystem openStorageSystem(String mainPartitionName) throws StorageException {
        return this.partitionedStorage.getPartition(mainPartitionName);
    }

    @Override
    public void close() {
    }

    public IStorageSystem getUnderlyingStorageSystem() {
        return this.underlyingStorage;
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        return Optional.empty();
    }
}

