/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.StorageIterator;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.FunctionWithTwoExceptions;

public class StorageIterators {
    public static <T, M, E extends Exception> StorageIterator<M, E> mapSequentially(final StorageIterator<T, E> inputIterator, final FunctionWithTwoExceptions<T, M, StorageException, E> mapper) {
        return new StorageIterator<M, E>(){

            @Override
            public boolean hasNext() throws StorageException, Exception {
                return inputIterator.hasNext();
            }

            @Override
            public M next() throws StorageException, Exception {
                return mapper.apply(inputIterator.next());
            }
        };
    }

    public static <T1, T2, E extends Exception> StorageIterator<Pair<T1, T2>, E> zip(final StorageIterator<T1, E> firstIterator, final StorageIterator<T2, E> secondIterator) {
        return new StorageIterator<Pair<T1, T2>, E>(){

            @Override
            public boolean hasNext() throws StorageException, Exception {
                return firstIterator.hasNext() && secondIterator.hasNext();
            }

            @Override
            public Pair<T1, T2> next() throws StorageException, Exception {
                return Pair.createPair(firstIterator.next(), secondIterator.next());
            }
        };
    }

    public static <T, R, E extends Exception> StorageIterator<T, E> filterOnReduce(final StorageIterator<T, E> inputIterator, final R initialValue, final ReducingFilter<T, R> reducingFilter, final @Nullable Function<R, Boolean> terminationCheck) {
        return new StorageIterator<T, E>(){
            private R reduced;
            private T nextMatching;
            private boolean hasCachedNext;
            {
                this.reduced = initialValue;
                this.nextMatching = null;
                this.hasCachedNext = false;
            }

            @Override
            public boolean hasNext() throws StorageException, Exception {
                if (terminationCheck != null && ((Boolean)terminationCheck.apply(this.reduced)).booleanValue()) {
                    return false;
                }
                if (!this.hasCachedNext) {
                    this.nextMatching = null;
                    while (inputIterator.hasNext()) {
                        Object candidate = inputIterator.next();
                        ReductionFilterResult filterResult = reducingFilter.filter(candidate, this.reduced);
                        if (!filterResult.matches) continue;
                        this.reduced = filterResult.reducedTo;
                        this.nextMatching = candidate;
                        break;
                    }
                    this.hasCachedNext = true;
                }
                return this.nextMatching != null;
            }

            @Override
            public T next() {
                this.hasCachedNext = false;
                return this.nextMatching;
            }
        };
    }

    public static <T, E extends Exception> StorageIterator<List<T>, E> makeBlockIterator(StorageIterator<T, E> inputIterator, int maxBlockLength) {
        return StorageIterators.makeBlockIterator(inputIterator, element -> 1, maxBlockLength);
    }

    public static <T, E extends Exception> StorageIterator<List<T>, E> makeBlockIterator(final StorageIterator<T, E> inputIterator, final Function<T, Integer> elementCostsFunction, final int maxCostsPerBlock) {
        return new StorageIterator<List<T>, E>(){

            @Override
            public boolean hasNext() throws StorageException, Exception {
                return inputIterator.hasNext();
            }

            @Override
            public List<T> next() throws StorageException, Exception {
                ArrayList block = new ArrayList();
                int blockCosts = 0;
                while (this.hasNext()) {
                    Object element = inputIterator.next();
                    block.add(element);
                    if ((blockCosts += ((Integer)elementCostsFunction.apply(element)).intValue()) <= maxCostsPerBlock) continue;
                    break;
                }
                return block;
            }
        };
    }

    public static <T, E extends Exception> StorageIterator<T, E> flattenIterator(final StorageIterator<List<T>, E> inputIterator) {
        return new StorageIterator<T, E>(){
            private Iterator<T> activeBlock;

            @Override
            public boolean hasNext() throws StorageException, Exception {
                if (this.activeBlock == null) {
                    return inputIterator.hasNext();
                }
                return this.activeBlock.hasNext() || inputIterator.hasNext();
            }

            @Override
            public T next() throws StorageException, Exception {
                if (this.activeBlock == null || !this.activeBlock.hasNext()) {
                    this.activeBlock = ((List)inputIterator.next()).iterator();
                }
                return this.activeBlock.next();
            }
        };
    }

    public static <T, E extends Exception> StorageIterator<T, E> asStorageIterator(final Iterable<T> iterable) {
        return new StorageIterator<T, E>(){
            private final Iterator<T> it;
            {
                this.it = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return this.it.next();
            }
        };
    }

    public static <T, E extends Exception> List<T> toList(StorageIterator<T, E> iterator) throws StorageException, E {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T, E extends Exception> List<T> extractSubList(StorageIterator<T, E> iterator, int startIndex, int maxElements) throws StorageException, E {
        int index = 0;
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext() && (result.size() < maxElements || maxElements < 0)) {
            T element = iterator.next();
            if (index >= startIndex) {
                result.add(element);
            }
            ++index;
        }
        return result;
    }

    @FunctionalInterface
    public static interface ReducingFilter<E, R> {
        public ReductionFilterResult<R> filter(E var1, R var2);
    }

    public record ReductionFilterResult<R>(boolean matches, R reducedTo) {
    }
}

