/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.base;

import java.util.Optional;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemBase;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class DelegatingStorageSystemProviderBase
implements IStorageSystemProvider {
    protected final IStorageSystemProvider storageSystemProvider;

    protected DelegatingStorageSystemProviderBase(IStorageSystemProvider storageSystemProvider) {
        this.storageSystemProvider = storageSystemProvider;
    }

    @Override
    public IStorageSystem openStorageSystem(final String storageSystemName) throws StorageException {
        return new DelegatingStorageSystemBase(this.storageSystemProvider.openStorageSystem(storageSystemName)){

            @Override
            public IStore openStore(String name) throws StorageException {
                return DelegatingStorageSystemProviderBase.this.wrapStore(super.openStore(name), name, storageSystemName);
            }
        };
    }

    protected abstract IStore wrapStore(IStore var1, String var2, String var3) throws StorageException;

    @Override
    public void removeStorageSystem(String partitionName) throws StorageException {
        this.storageSystemProvider.removeStorageSystem(partitionName);
    }

    @Override
    public void close() throws StorageException {
        this.storageSystemProvider.close();
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        return this.storageSystemProvider.getCapability(capability);
    }

    @VisibleForTesting
    public IStorageSystemProvider getDelegatedStorageSystemProvider() {
        return this.storageSystemProvider;
    }

    @Override
    public void warmUpStorageSystem(InternalProjectId internalProjectId) throws StorageException {
        this.storageSystemProvider.warmUpStorageSystem(internalProjectId);
    }
}

