/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.ICompactionCapability;
import org.conqat.engine.persistence.store.capability.IPeriodicMaintenanceCapability;
import org.conqat.engine.persistence.store.capability.IStorageInfoCapability;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.capability.RemovalCostCapability;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageSystemIdManager;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class SingleStoreStorageSystemProviderBase
implements IStorageSystemProvider,
IStorageInfoCapability,
IPeriodicMaintenanceCapability,
ICompactionCapability {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int STORE_PREFIX_LENGTH = 8;
    protected static final byte[] META_DATA_STORE_PREFIX = ByteArrayUtils.intToByteArray((int)0);
    protected static final byte[] DELETION_ENTRY_PREFIX = ByteArrayUtils.concat((byte[][])new byte[][]{META_DATA_STORE_PREFIX, {0}});
    private int nextStorePartitionId = 1;
    private final Map<String, Integer> partitionToIdMapping = new HashMap<String, Integer>();
    private int nextStorageSystemPartitionId = 1;
    private boolean shutdown = false;
    private IStore singletonStore;

    protected void init(IStore singletonStore) throws StorageException {
        CCSMAssert.isTrue((this.singletonStore == null ? 1 : 0) != 0, (String)"May not initialize twice!");
        this.singletonStore = singletonStore;
        PairList partitionKeys = new PairList();
        singletonStore.scan(META_DATA_STORE_PREFIX, (IKeyValueCallback)new KeyValueCollectingCallback((PairList<byte[], byte[]>)partitionKeys));
        for (Pair rawPartitionKey : partitionKeys) {
            PartitionKey key = PartitionKey.deserialize((byte[])rawPartitionKey.getSecond());
            this.nextStorePartitionId = Math.max(this.nextStorePartitionId, key.storePartitionId + 1);
            this.nextStorageSystemPartitionId = Math.max(this.nextStorageSystemPartitionId, key.storageSystemPartitionId + 1);
            Pair<String, String> partitionAndStore = SingleStoreStorageSystemProviderBase.parseMetaDataStoreKey((byte[])rawPartitionKey.getFirst());
            this.partitionToIdMapping.put((String)partitionAndStore.getFirst(), key.storageSystemPartitionId);
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void close() {
        this.shutdown = true;
    }

    @Override
    public IStorageSystem openStorageSystem(String storageSystemName) throws StorageException {
        this.throwIfShutdown();
        return new LogicalTableStorageSystem(storageSystemName, StorageSystemIdManager.getInstance().getOrCreateId(storageSystemName));
    }

    private void throwIfShutdown() throws StorageException {
        if (this.isShutdown()) {
            throw new StorageException("Storage system is already shut down!");
        }
    }

    @Override
    public void removeStorageSystem(String storageSystemName) throws StorageException {
        this.throwIfShutdown();
        StorageSystemIdManager.getInstance().removeStorageSystem(storageSystemName);
        List<String> storeNames = Collections.synchronizedList(new ArrayList());
        byte[] prefix = SingleStoreStorageSystemProviderBase.makeMetaDataStoreKey(storageSystemName, "");
        this.singletonStore.scan(prefix, (key, value) -> storeNames.add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, prefix.length, key.length))));
        for (String storeName : storeNames) {
            this.deleteLogicalStore(storageSystemName, storeName);
        }
    }

    private void deleteLogicalStore(String storageSystemName, String storeName) throws StorageException {
        Optional<PartitionKey> id = this.getPartitionId(storageSystemName, storeName);
        if (id.isEmpty()) {
            return;
        }
        this.singletonStore.remove(SingleStoreStorageSystemProviderBase.makeMetaDataStoreKey(storageSystemName, storeName));
        this.singletonStore.put(SingleStoreStorageSystemProviderBase.makeIdDeletionKey(id.get()), id.get().serialize());
    }

    private Optional<PartitionKey> getPartitionId(String storageSystemName, String storeName) throws StorageException {
        byte[] data = this.singletonStore.get(SingleStoreStorageSystemProviderBase.makeMetaDataStoreKey(storageSystemName, storeName));
        return Optional.ofNullable(data).map(PartitionKey::deserialize);
    }

    private static byte[] makeIdDeletionKey(PartitionKey id) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DELETION_ENTRY_PREFIX, id.serialize()});
    }

    private static byte[] makeMetaDataStoreKey(String storageSystemName, String storeName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{META_DATA_STORE_PREFIX, StringUtils.stringToBytes((String)storageSystemName), META_DATA_STORE_PREFIX, StringUtils.stringToBytes((String)storeName)});
    }

    private static Pair<String, String> parseMetaDataStoreKey(byte[] key) {
        List splitResult = ByteArrayUtils.split((byte[])key, (byte[])META_DATA_STORE_PREFIX);
        String partitionName = StringUtils.bytesToString((byte[])((byte[])splitResult.get(0)));
        String storeName = StringUtils.bytesToString((byte[])((byte[])splitResult.get(1)));
        return Pair.createPair((Object)partitionName, (Object)storeName);
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        if (capability == RemovalCostCapability.class) {
            return Optional.of(new RemovalCostCapability(true, true));
        }
        if (capability == IStorageInfoCapability.class || capability == IPeriodicMaintenanceCapability.class) {
            return Optional.of(this);
        }
        if (capability == ICompactionCapability.class && this.doesOsSupportCompaction()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    protected boolean doesOsSupportCompaction() {
        return true;
    }

    @Override
    public String getStorageInfo() throws StorageException {
        this.throwIfShutdown();
        final StringBuilder builder = new StringBuilder();
        builder.append(this.getStorageSystemName()).append("\n===================\n\n");
        final HashSet waitingForDeletion = new HashSet();
        this.singletonStore.scan(META_DATA_STORE_PREFIX, new IKeyValueCallback(){

            @Override
            public synchronized void callback(byte[] key, byte[] value) {
                int id = PartitionKey.deserialize((byte[])value).storageSystemPartitionId;
                if (ByteArrayUtils.isPrefix((byte[])DELETION_ENTRY_PREFIX, (byte[])key)) {
                    waitingForDeletion.add(id);
                } else {
                    Pair<String, String> storageSystemAndStoreName = SingleStoreStorageSystemProviderBase.getStorageSystemAndStoreFromMetaDataKey(key);
                    builder.append((String)storageSystemAndStoreName.getFirst()).append(":").append((String)storageSystemAndStoreName.getSecond()).append(" -> ").append(id).append("\n");
                }
            }
        });
        builder.append("\n\nWaiting for deletion: ").append(CollectionUtils.sort(waitingForDeletion));
        return builder.toString();
    }

    protected static Pair<String, String> getStorageSystemAndStoreFromMetaDataKey(byte[] key) {
        int index = ByteArrayUtils.indexOf((byte[])META_DATA_STORE_PREFIX, (byte[])key, (int)META_DATA_STORE_PREFIX.length);
        String storageSystem = StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, META_DATA_STORE_PREFIX.length, index));
        String store = StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, index + META_DATA_STORE_PREFIX.length, key.length));
        return Pair.createPair((Object)storageSystem, (Object)store);
    }

    protected abstract String getStorageSystemName();

    @Override
    public void performMaintenance(ICancelable cancelable) throws StorageException {
        this.throwIfShutdown();
        HashSet waitingForDeletion = new HashSet();
        this.singletonStore.scan(META_DATA_STORE_PREFIX, (key, value) -> {
            if (ByteArrayUtils.isPrefix((byte[])DELETION_ENTRY_PREFIX, (byte[])key)) {
                Set set = waitingForDeletion;
                synchronized (set) {
                    waitingForDeletion.add(value);
                }
            }
        });
        for (byte[] rawKey : waitingForDeletion) {
            if (cancelable.isCanceled()) break;
            PartitionKey partitionKey = PartitionKey.deserialize(rawKey);
            this.singletonStore.removeByPrefix(rawKey);
            this.singletonStore.remove(SingleStoreStorageSystemProviderBase.makeIdDeletionKey(partitionKey));
            LOGGER.info("Deleted logical table {}", (Object)partitionKey.toString());
        }
    }

    protected static final class PartitionKey {
        private final int storageSystemPartitionId;
        private final int storePartitionId;

        private PartitionKey(int storageSystemPartitionId, int storePartitionId) {
            this.storageSystemPartitionId = storageSystemPartitionId;
            this.storePartitionId = storePartitionId;
        }

        public byte @NonNull [] serialize() {
            return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)this.storageSystemPartitionId), ByteArrayUtils.intToByteArray((int)this.storePartitionId)});
        }

        public static @NonNull PartitionKey deserialize(byte[] data) {
            return new PartitionKey(ByteArrayUtils.readIntFromStartOfArray((byte[])data), ByteArrayUtils.getIntFromByteArray((byte[])data, (int)4));
        }

        public String toString() {
            return this.storageSystemPartitionId + "-" + this.storePartitionId;
        }
    }

    private class LogicalTableStorageSystem
    implements IStorageSystem {
        private final String storageSystemName;
        private final int storageSystemId;

        private LogicalTableStorageSystem(String storageSystemName, int storageSystemId) {
            this.storageSystemName = storageSystemName;
            this.storageSystemId = storageSystemId;
        }

        @Override
        public IStore openStore(String storeName) throws StorageException {
            SingleStoreStorageSystemProviderBase.this.throwIfShutdown();
            PartitionKey id = this.getOrCreateId(storeName);
            return new DelegatingPartitionStore(SingleStoreStorageSystemProviderBase.this.singletonStore, id.serialize(), id.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PartitionKey getOrCreateId(String storeName) throws StorageException {
            Optional<PartitionKey> id = SingleStoreStorageSystemProviderBase.this.getPartitionId(this.storageSystemName, storeName);
            if (id.isPresent()) {
                return id.get();
            }
            IStore iStore = SingleStoreStorageSystemProviderBase.this.singletonStore;
            synchronized (iStore) {
                id = SingleStoreStorageSystemProviderBase.this.getPartitionId(this.storageSystemName, storeName);
                if (id.isPresent()) {
                    return id.get();
                }
                int nextPartition = this.getNextPartitionId(this.storageSystemName);
                PartitionKey nextKey = new PartitionKey(nextPartition, SingleStoreStorageSystemProviderBase.this.nextStorePartitionId);
                ++SingleStoreStorageSystemProviderBase.this.nextStorePartitionId;
                SingleStoreStorageSystemProviderBase.this.singletonStore.put(SingleStoreStorageSystemProviderBase.makeMetaDataStoreKey(this.storageSystemName, storeName), nextKey.serialize());
                return nextKey;
            }
        }

        private int getNextPartitionId(String storageSystemName) {
            return SingleStoreStorageSystemProviderBase.this.partitionToIdMapping.computeIfAbsent(storageSystemName, key -> SingleStoreStorageSystemProviderBase.this.nextStorageSystemPartitionId++);
        }

        @Override
        public void removeStore(String storeName) throws StorageException {
            SingleStoreStorageSystemProviderBase.this.throwIfShutdown();
            SingleStoreStorageSystemProviderBase.this.deleteLogicalStore(this.storageSystemName, storeName);
        }

        @Override
        public int getStorageSystemId() {
            return this.storageSystemId;
        }
    }
}

