/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.instance_comparison;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.commons.service.client.HttpRequest;
import com.teamscale.commons.service.client.IDeserializationFormat;
import com.teamscale.commons.service.client.ISerializationFormat;
import com.teamscale.commons.service.client.ServerDetails;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.commons.service.client.ServiceClientCallable;
import com.teamscale.commons.service.client.ServiceClientUris;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.admin.instance_comparison.EInstanceComparisonStatus;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationIndex;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationMetadata;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationOptions;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationTrigger;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonResultBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonSnapshotLoader;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonExternalSnapshotIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationOptions;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationTrigger;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotDto;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/instance-comparison")
public class InstanceComparisonService
extends ApiBase {
    @POST
    @Path(value="snapshots")
    @Operation(summary="Create snapshot", description="Triggers creation of a snapshot of this instance and returns the ID of the created snapshot. Additionally, a remote snapshot with the same parameters can be created and a comparison between the two scheduled.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createSnapshot(@BeanParam CreateSnapshotParameters createSnapshotParameters) throws BadRequestException, ConQATException {
        String snapshotId = UUID.randomUUID().toString();
        long endTimestamp = System.currentTimeMillis();
        if (!StringUtils.isEmpty((String)createSnapshotParameters.getEndTimestampString())) {
            endTimestamp = Long.parseLong(createSnapshotParameters.getEndTimestampString());
        }
        List projectIds = ProjectUtils.resolveToPrimaryPublicId((List)this.getPermissions().getVisibleProjects());
        InstanceComparisonSnapshotCreationOptions options = new InstanceComparisonSnapshotCreationOptions(this.getUser().getUsername(), projectIds, createSnapshotParameters.getProjectInclusionPattern(), createSnapshotParameters.getProjectExclusionPattern(), Long.valueOf(endTimestamp), createSnapshotParameters.isDetailedSnapshot(), createSnapshotParameters.getBranchName());
        InstanceComparisonSnapshotMetaData snapshotMetaData = new InstanceComparisonSnapshotMetaData(snapshotId, options, DateTimeUtils.millisNow(), this.getInstanceName());
        this.writeSnapshot(snapshotMetaData);
        if (!StringUtils.isEmpty((String)createSnapshotParameters.getShouldScheduleRemoteComparison()) && createSnapshotParameters.getShouldScheduleRemoteComparison().equals("on")) {
            this.requestRemoteComparison(snapshotId, options, this.getRemoteInstanceCredentials(createSnapshotParameters.getRemoteUrl(), createSnapshotParameters.getRemoteUserName(), createSnapshotParameters.getRemoteAccessToken()));
        }
        this.scheduleInstanceComparisonSnapshotCreationTrigger(snapshotId);
        return snapshotId;
    }

    @POST
    @Path(value="snapshots/external")
    @Operation(summary="Upload snapshot", description="Uploads an external snapshot for comparison", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"multipart/form-data"})
    public void uploadExternalSnapshot(@Parameter(description="Name of the external snapshot") @FormDataParam(value="snapshot-name") String snapshotName, @Parameter(description="The snapshot file", schema=@Schema(type="string", format="binary")) @FormDataParam(value="snapshot") FormDataBodyPart snapshotFile) throws StorageException {
        InstanceComparisonSnapshotDto snapshot = (InstanceComparisonSnapshotDto)snapshotFile.getValueAs(InstanceComparisonSnapshotDto.class);
        InstanceComparisonExternalSnapshotIndex index = this.openGlobalIndex(InstanceComparisonExternalSnapshotIndex.class);
        index.storeSnapshot(Optional.ofNullable(snapshotName).filter(Predicate.not(StringUtils::isEmpty)).orElseGet(() -> ((InstanceComparisonSnapshotDto)snapshot).id()), this.getUser().getUsername(), snapshot);
    }

    @GET
    @Path(value="snapshots/external")
    @Operation(summary="Get external snapshots", description="Returns the list of all available externally uploaded snapshots", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<ExternalInstanceComparisonSnapshotDto> getAllExternalSnapshots(@Parameter(description="Whether only the IDs of the snapshots created by the currently logged in user should be returned") @QueryParam(value="only-current-user") boolean onlyCurrentUser) throws StorageException {
        String username = null;
        if (onlyCurrentUser) {
            username = this.getUser().getUsername();
        }
        InstanceComparisonExternalSnapshotIndex index = this.openGlobalIndex(InstanceComparisonExternalSnapshotIndex.class);
        return index.getAllMetaData(username).stream().map(ExternalInstanceComparisonSnapshotDto::of).toList();
    }

    @DELETE
    @Path(value="snapshots/external/{name}")
    @Operation(summary="Delete external snapshots", description="Deletes the external snapshot with the provided name", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void deleteExternalSnapshot(@Parameter(description="The name of the external snapshot to be deleted") @PathParam(value="name") String snapshotName) throws StorageException {
        InstanceComparisonExternalSnapshotIndex index = this.openGlobalIndex(InstanceComparisonExternalSnapshotIndex.class);
        index.deleteSnapshot(snapshotName);
    }

    @GET
    @Path(value="snapshots/ids")
    @Operation(summary="Get snapshot IDs", description="Returns the list of all available snapshot IDs. ", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<String> getAllSnapshotIds(@Parameter(description="Whether only the IDs of the snapshots created by the currently logged in user should be returned") @QueryParam(value="only-current-user") boolean onlyCurrentUser) throws StorageException {
        InstanceComparisonSnapshotCreationIndex snapshotIndex = this.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class);
        Stream<Object> snapshots = snapshotIndex.getAllSnapshotsMetaData().stream();
        if (onlyCurrentUser) {
            String username = this.getUser().getUsername();
            snapshots = snapshots.filter(snapshot -> snapshot.getOptions().getUsername().equals(username));
        }
        return snapshots.sorted(Comparator.comparingLong(InstanceComparisonSnapshotMetaData::getCreatedOn).reversed()).map(InstanceComparisonSnapshotMetaData::getId).toList();
    }

    @GET
    @Path(value="snapshots/{id}")
    @Operation(summary="Get a snapshot", description="Returns a single snapshot identified by the given ID or ID prefix. The ID (prefix) must not be empty, but can be as short as one character, as long as it unambiguously identifies the snapshot to be returned.", tags={"Instance Comparison"})
    @ApiResponse(content={@Content(schema=@Schema(implementation=InstanceComparisonSnapshotDto.class))}, description="default response")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response getSnapshot(@Parameter(description="The ID of the snapshot to get. May be an incomplete prefix, as long as it is unambiguous.") @PathParam(value="id") String snapshotId, @Parameter(description="A flag whether or not the detailed comparison inputs should be included in the reply") @QueryParam(value="reduced") boolean isReduced, @Parameter(description="Whether the response should be a file download") @QueryParam(value="asFileDownload") @DefaultValue(value="false") boolean asFileDownload) throws StorageException {
        InstanceComparisonSnapshotCreationIndex snapshotIndex = this.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class);
        InstanceComparisonSnapshotMetaData snapshotMetaData = InstanceComparisonService.getSnapshotForPrefix(snapshotId, this.getUser().getUsername(), snapshotIndex);
        InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions contributions = InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions.EMPTY;
        if (!isReduced && snapshotMetaData.getStatus() == EInstanceComparisonStatus.SUCCESS) {
            contributions = InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions.of((Collection)snapshotIndex.getAllSnapshotContributions(snapshotMetaData.getId()));
        }
        InstanceComparisonSnapshotDto result = InstanceComparisonSnapshotDto.of((InstanceComparisonSnapshotMetaData)snapshotMetaData, (InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions)contributions);
        if (asFileDownload) {
            return ResponseUtils.getFileDownloadResponse((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE, (String)("instance_comparison_snapshot_" + snapshotId + ".json"));
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @DELETE
    @Path(value="snapshots/{id}")
    @Operation(summary="Delete snapshot", description="Permanently deletes the given snapshot and all associated comparisons.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void deleteSnapshot(@Parameter(description="The ID of the snapshot to delete.") @PathParam(value="id") String snapshotId) throws BadRequestException, ConQATException {
        this.withSnapshotLock((RunnableWithException<StorageException>)((RunnableWithException)() -> {
            InstanceComparisonSnapshotCreationIndex snapshotIndex = this.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class);
            snapshotIndex.removeSnapshot(snapshotId);
            this.openGlobalIndex(InstanceComparisonComputationIndex.class).removeAllComparisons(snapshotId);
        }));
    }

    @GET
    @Path(value="snapshots/{id}/status")
    @Operation(summary="Get a snapshot status", description="Returns the status (IN_PROGRESS, SUCCESS or FAILURE) of a single status identified by the given ID or ID prefix. The ID (prefix) must not be empty, but can be as short as one character, as long as it unambiguously identifies a status. Only snapshots created by the logged-in user are considered for this operation.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public EInstanceComparisonStatus getSnapshotStatus(@Parameter(description="The ID of the snapshot. May be an incomplete prefix, as long as it is unambiguous.") @PathParam(value="id") String snapshotId) throws StorageException {
        InstanceComparisonSnapshotCreationIndex snapshotIndex = this.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class);
        return InstanceComparisonService.getSnapshotForPrefix(snapshotId, this.getUser().getUsername(), snapshotIndex).getStatus();
    }

    @POST
    @Path(value="snapshots/{snapshotId}/comparisons")
    @Operation(summary="Trigger comparison computation", description="Triggers computation of the comparison between two snapshots and returns the ID of the new comparison. One of the snapshots is stored locally, the other fetched from a remote instance.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createComparison(@Parameter(description="The ID of the local snapshot.") @PathParam(value="snapshotId") String localSnapshotId, @Parameter(description="The ID of the remote snapshot. May be empty or an incomplete prefix, as long as exactly one remote snapshot is uniquely identified.") @FormParam(value="remote-snapshot-id") String remoteSnapshotId, @Parameter(description="The name of the externally uploaded snapshot. If provided, the remote-snapshot-id must not be provided.") @FormParam(value="external-snapshot-name") String externalSnapshotName, @Parameter(description="URL of the remote instance") @FormParam(value="remote-url") String remoteUrl, @Parameter(description="User name for the remote instance. May be empty, in this case locally logged in user is assumed.") @FormParam(value="remote-user") String remoteUserName, @Parameter(description="Access token for the remote instance.") @FormParam(value="remote-access-token") String remoteAccessToken) throws ConQATException {
        if (!StringUtils.isEmpty((String)externalSnapshotName)) {
            if (!StringUtils.isEmpty((String)remoteSnapshotId)) {
                throw new BadRequestException("external-snapshot-name cannot be provided together with remote-snapshot-id");
            }
            InstanceComparisonExternalSnapshotIndex externalSnapshotIndex = this.openGlobalIndex(InstanceComparisonExternalSnapshotIndex.class);
            InstanceComparisonSnapshotDto externalSnapshot = (InstanceComparisonSnapshotDto)externalSnapshotIndex.getSnapshot(externalSnapshotName).orElseThrow(() -> new NotFoundException("External snapshot \"%s\" not found.".formatted(externalSnapshotName)));
            InstanceCredentials remoteCredentials = null;
            if (remoteUrl != null) {
                remoteCredentials = new InstanceCredentials(remoteUrl, externalSnapshot.options().getUsername(), null);
            }
            return this.createComparison(localSnapshotId, externalSnapshotName, remoteCredentials, true);
        }
        return this.createComparison(localSnapshotId, remoteSnapshotId, this.getRemoteInstanceCredentials(remoteUrl, remoteUserName, remoteAccessToken), false);
    }

    @GET
    @Path(value="snapshots/{id}/comparisons/ids")
    @Operation(summary="Get associated comparison IDs", description="Returns the IDs of the associated comparisons of a single snapshot identified by the given ID.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<String> getAssociatedComparisonIds(@Parameter(description="The ID of the snapshot.") @PathParam(value="id") String snapshotId) throws StorageException {
        List comparisons = this.openGlobalIndex(InstanceComparisonComputationIndex.class).getReferencedComparisons(snapshotId);
        return comparisons.stream().sorted(Comparator.comparingLong(InstanceComparisonComputationMetadata::getCreatedOn).reversed()).map(InstanceComparisonComputationMetadata::getId).toList();
    }

    @GET
    @Path(value="snapshots/{snapshotId}/comparisons/{comparisonId}")
    @Operation(summary="Get comparison summary", description="Returns the global comparison data, the projects and the contributors for the projects for a single comparison identified by the given ID.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public InstanceComparisonComputationMetadata getComparison(@Parameter(description="The ID of the local snapshot the comparison belongs to.") @PathParam(value="snapshotId") String snapshotId, @Parameter(description="The ID of the snapshot to get. May be an incomplete prefix, as long as it is unambiguous.") @PathParam(value="comparisonId") String comparisonId) throws StorageException {
        return InstanceComparisonService.getComparisonComputation(snapshotId, comparisonId, this.openGlobalIndex(InstanceComparisonComputationIndex.class));
    }

    public static @NonNull InstanceComparisonComputationMetadata getComparisonComputation(String snapshotId, String comparisonId, InstanceComparisonComputationIndex comparisonIndex) throws StorageException {
        return (InstanceComparisonComputationMetadata)comparisonIndex.getComparisonMetadata(snapshotId, comparisonId).orElseThrow(() -> new NotFoundException("Could not find comparison with id \"%s\" for snapshot with id \"%s\"".formatted(comparisonId, snapshotId)));
    }

    @DELETE
    @Path(value="snapshots/{snapshotId}/comparisons/{comparisonId}")
    @Operation(summary="Delete comparison", description="Permanently deletes the given comparison.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void deleteComparison(@Parameter(description="The ID of the local snapshot the comparison belongs to.") @PathParam(value="snapshotId") String snapshotId, @Parameter(description="The ID of the comparison to delete.") @PathParam(value="comparisonId") String comparisonId) throws ConQATException {
        InstanceComparisonComputationIndex comparisonIndex = this.openGlobalIndex(InstanceComparisonComputationIndex.class);
        comparisonIndex.removeComparison(snapshotId, comparisonId);
    }

    @GET
    @Path(value="snapshots/{snapshotId}/comparisons/{comparisonId}/result")
    @Operation(summary="Get comparison result metadata", description="Returns the comparison metadata for the specified comparison. The comparison can be identified by the given ID.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Cache(eTagContributors={RequestContributor.class}, maxAge=31536000)
    public Map<String, Map<String, InstanceComparisonResultMetadata>> getComparisonResultMetadata(@Parameter(description="The ID of the local snapshot the comparison belongs to.") @PathParam(value="snapshotId") String snapshotId, @Parameter(description="The ID of the comparison to get.") @PathParam(value="comparisonId") String comparisonId) throws StorageException, ExecutionException, InterruptedException {
        InstanceComparisonComputationIndex computationIndex = this.openGlobalIndex(InstanceComparisonComputationIndex.class);
        InstanceComparisonComputationMetadata comparisonComputation = InstanceComparisonService.getComparisonComputation(snapshotId, comparisonId, computationIndex);
        List resultIds = comparisonComputation.getContributorsByProject().entrySet().stream().flatMap(entry -> ((UnmodifiableSet)entry.getValue()).stream().map(contributor -> {
            record ResultId(String project, String contributor) {
            }
            return new ResultId((String)entry.getKey(), (String)contributor);
        })).toList();
        return (Map)this.getParallelTaskExecutor().computeInParallel(resultIds, resultId -> (InstanceComparisonResultBase)computationIndex.getResult(snapshotId, comparisonId, resultId.project(), resultId.contributor()).orElseThrow(() -> new IllegalStateException(InstanceComparisonService.comparisonResultNotFoundMessage(comparisonId, resultId.project(), resultId.contributor()))), Collectors.groupingBy(InstanceComparisonResultBase::getProject, Collectors.toMap(InstanceComparisonResultBase::getContributor, InstanceComparisonResultMetadata::of)));
    }

    @GET
    @Path(value="snapshots/{snapshotId}/comparisons/{comparisonId}/{projectId}/{contributor}")
    @Operation(summary="Get specific project comparison results", description="Returns the comparison data for the specified comparison, project and contributor. The comparison can be identified by the given ID.", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Cache(eTagContributors={RequestContributor.class}, maxAge=31536000)
    public InstanceComparisonResultBase getComparisonResult(@Parameter(description="The ID of the local snapshot the comparison belongs to.") @PathParam(value="snapshotId") String snapshotId, @Parameter(description="The ID of the comparison to get.") @PathParam(value="comparisonId") String comparisonId, @PathParam(value="projectId") String projectId, @PathParam(value="contributor") String contributor) throws StorageException {
        return (InstanceComparisonResultBase)this.openGlobalIndex(InstanceComparisonComputationIndex.class).getResult(snapshotId, comparisonId, projectId, contributor).orElseThrow(() -> new NotFoundException(InstanceComparisonService.comparisonResultNotFoundMessage(comparisonId, projectId, contributor)));
    }

    private static @NonNull String comparisonResultNotFoundMessage(String comparisonId, String project, String contributor) {
        Object message = "Comparison result of '%s' cannot be found in comparison '%s'".formatted(contributor, comparisonId);
        if (!"##maintenance##".equals(project)) {
            message = (String)message + " for project '%s'".formatted(project);
        }
        return message;
    }

    @GET
    @Path(value="snapshots/{snapshotId}/comparisons/{comparisonId}/{project}/{contributor}/{diffEntryName}")
    @Operation(summary="Get complete example list", description="Get the full list of missing local or remote detail values", tags={"Instance Comparison"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<DetailedInstanceComparisonValue> getCompleteExampleList(@Parameter(description="The ID of the local snapshot the comparison belongs to.") @PathParam(value="snapshotId") String snapshotId, @Parameter(description="The ID of the comparison to get.") @PathParam(value="comparisonId") String comparisonId, @Parameter(description="The name of the project.") @PathParam(value="project") String project, @Parameter(description="The contributor of the comparison.") @PathParam(value="contributor") String contributor, @Parameter(description="The name of the difference entry.") @PathParam(value="diffEntryName") String diffEntryName, @Parameter(description="Whether the \"missingLocal\" or \"missingRemote\" value is requested.") @QueryParam(value="missingLocal") boolean missingLocal) throws StorageException {
        InstanceComparisonComputationIndex computationIndex = this.openGlobalIndex(InstanceComparisonComputationIndex.class);
        InstanceComparisonResultBase comparisonResult = (InstanceComparisonResultBase)computationIndex.getResult(snapshotId, comparisonId, project, contributor).orElseThrow(() -> new NotFoundException(InstanceComparisonService.comparisonResultNotFoundMessage(comparisonId, project, contributor)));
        InstanceComparisonDiffEntryExamples examples = Stream.of(comparisonResult.getDiffs(), comparisonResult.getOnlyInLocalInstance(), comparisonResult.getOnlyInRemoteInstance()).flatMap(Collection::stream).filter(diffEntry -> diffEntryName.equals(diffEntry.getName())).map(InstanceComparisonDiffEntryBase::getExamples).findFirst().orElseThrow(() -> new NotFoundException("Diff entry '%s' cannot be found in the result of '%s' in comparison '%s' for project '%s'".formatted(diffEntryName, contributor, comparisonId, project)));
        if (missingLocal) {
            return examples.getMissingLocal();
        }
        return examples.getMissingRemote();
    }

    public static @NonNull InstanceComparisonSnapshotMetaData getSnapshotForPrefix(String snapshotIdPrefix, String username, InstanceComparisonSnapshotCreationIndex snapshotIndex) throws StorageException {
        List snapshotMatches = snapshotIndex.getSnapshotMetaDataByPrefix(snapshotIdPrefix);
        if (snapshotMatches.size() > 1) {
            snapshotMatches = CollectionUtils.filter((Collection)snapshotMatches, snapshotMatch -> snapshotMatch.getOptions().getUsername().equals(username));
        }
        if (snapshotMatches.isEmpty()) {
            throw new NotFoundException("Snapshot with ID " + snapshotIdPrefix + " was not found.");
        }
        if (snapshotMatches.size() > 1) {
            throw new BadRequestException("More than one snapshot with ID prefix " + snapshotIdPrefix + " found.");
        }
        return (InstanceComparisonSnapshotMetaData)snapshotMatches.get(0);
    }

    private String createComparison(String localSnapshotId, String remoteSnapshotId, @Nullable InstanceCredentials remoteInstanceCredentials, boolean externallyUploadedSnapshot) throws StorageException {
        String comparisonId = UUID.randomUUID().toString();
        InstanceComparisonComputationMetadata comparison = new InstanceComparisonComputationMetadata(comparisonId, new InstanceComparisonComputationOptions(remoteInstanceCredentials, localSnapshotId, remoteSnapshotId, externallyUploadedSnapshot, this.getUser().getUsername()));
        this.writeComparison(localSnapshotId, comparison);
        this.scheduleInstanceComparisonComputationTrigger(localSnapshotId, comparisonId);
        return comparisonId;
    }

    private String getInstanceName() {
        return this.serviceInfo.getServerConfiguration().getInstanceName();
    }

    private void requestRemoteComparison(String localSnapshotId, InstanceComparisonSnapshotCreationOptions options, InstanceCredentials remoteInstanceCredentials) throws BadRequestException {
        InstanceComparisonService.ensureCredentialsAreValid(remoteInstanceCredentials);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("end-timestamp", String.valueOf(options.getEndTimestamp())));
        params.add((NameValuePair)new BasicNameValuePair("detailed-snapshot", String.valueOf(options.isDetailedSnapshot())));
        Optional.ofNullable(options.getProjectInclusionPattern()).ifPresent(option -> params.add((NameValuePair)new BasicNameValuePair("project-inclusion-pattern", option)));
        Optional.ofNullable(options.getProjectExclusionPattern()).ifPresent(option -> params.add((NameValuePair)new BasicNameValuePair("project-exclusion-pattern", option)));
        Optional.ofNullable(options.getBranchName()).ifPresent(option -> params.add((NameValuePair)new BasicNameValuePair("branch-name", option)));
        try {
            if (InstanceComparisonSnapshotLoader.isLegacyInstance((ServerDetails)remoteInstanceCredentials.toServerDetails())) {
                this.createComparison(localSnapshotId, "legacy-" + String.valueOf(UUID.randomUUID()), remoteInstanceCredentials, false);
                return;
            }
            String remoteSnapshotId = InstanceComparisonService.postSnapshotCreationRequest(params, remoteInstanceCredentials.toServerDetails());
            if (StringUtils.isEmpty((String)remoteSnapshotId)) {
                throw new BadRequestException("Error during request of remote snapshot creation");
            }
            this.createComparison(localSnapshotId, remoteSnapshotId, remoteInstanceCredentials, false);
        }
        catch (ServiceCallException | ConQATException e) {
            throw new BadRequestException("Error during request of remote snapshot creation", e);
        }
    }

    private static void ensureCredentialsAreValid(InstanceCredentials remoteInstanceCredentials) {
        String teamscaleUrl = remoteInstanceCredentials.getTeamscaleUrl();
        if (!teamscaleUrl.startsWith("http")) {
            throw new BadRequestException("Remote Teamscale URL \"" + teamscaleUrl + "\" doesn't have a valid protocol");
        }
        try {
            InstanceComparisonService.tryConnect(remoteInstanceCredentials.toServerDetails());
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode() || e.getStatusCode() == Response.Status.FORBIDDEN.getStatusCode()) {
                throw new BadRequestException("Invalid credentials provided for Teamscale instance under URL " + teamscaleUrl, (Throwable)e);
            }
            throw new BadRequestException("Remote Teamscale instance not reachable under URL " + teamscaleUrl, (Throwable)e);
        }
    }

    private static String postSnapshotCreationRequest(List<NameValuePair> params, ServerDetails serverDetails) throws ServiceCallException {
        return (String)HttpRequest.with((ServerDetails)serverDetails, (ServiceClientCallable)HttpRequest.post((ISerializationFormat)ISerializationFormat.toUrlEncodedFormData(), params, (IDeserializationFormat)IDeserializationFormat.fromJson(String.class), (String)ServiceClientUris.getGlobal((String)"instance-comparison/snapshots", (ServerDetails)serverDetails, (Pair[])new Pair[0])));
    }

    private static void tryConnect(ServerDetails serverDetails) throws ServiceCallException {
        HttpRequest.with((ServerDetails)serverDetails, (ServiceClientCallable)HttpRequest.get((IDeserializationFormat)IDeserializationFormat.fromJsonList(String.class), (String)ServiceClientUris.getGlobal((String)"projects/aliases", (ServerDetails)serverDetails, (Version)ETeamscaleVersion.VERSION_5_2_0.toVersionObject(), (Pair[])new Pair[0])));
    }

    private void writeSnapshot(InstanceComparisonSnapshotMetaData snapshotMetaData) throws StorageException {
        this.withSnapshotLock((RunnableWithException<StorageException>)((RunnableWithException)() -> this.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class).storeSnapshotMetaData(snapshotMetaData)));
    }

    private void writeComparison(String id, InstanceComparisonComputationMetadata comparison) throws StorageException {
        this.openGlobalIndex(InstanceComparisonComputationIndex.class).addComparison(id, comparison);
    }

    private void scheduleInstanceComparisonSnapshotCreationTrigger(String snapshotId) throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, InstanceComparisonSnapshotCreationTrigger.class, null, (Object)snapshotId, "Scheduled due to snapshot creation request '" + snapshotId + "'."));
    }

    private void scheduleInstanceComparisonComputationTrigger(String localSnapshotId, String comparisonId) throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, InstanceComparisonComputationTrigger.class, null, (Object)InstanceComparisonComputationIndex.makeSnapshotToComparisonKey((String)localSnapshotId, (String)comparisonId), "Scheduled due to instance comparison request '" + comparisonId + "'."));
    }

    private void withSnapshotLock(RunnableWithException<StorageException> criticalSection) throws StorageException {
        Lock lock = this.serviceInfo.getLockProvider().obtainLock("instance-comparison-snapshot-creation");
        lock.lock();
        try {
            criticalSection.run();
        }
        finally {
            lock.unlock();
        }
    }

    private static class CreateSnapshotParameters {
        @Parameter(description="The timestamp used to determine when to cut off comparison. Useful when one instance has an ongoing analysis, and the other does not.")
        @FormParam(value="end-timestamp")
        private String endTimestampString;
        @Parameter(description="Optional regex pattern to specify which projects should be included in the snapshot.")
        @FormParam(value="project-inclusion-pattern")
        private String projectInclusionPattern;
        @Parameter(description="Optional regex pattern to specify which projects should be excluded from the snapshot.")
        @FormParam(value="project-exclusion-pattern")
        private String projectExclusionPattern;
        @Parameter(description="Whether to schedule a comparison with a remote instance that uses the same parameters.")
        @FormParam(value="schedule-remote-comparison")
        private String shouldScheduleRemoteComparison;
        @Parameter(description="URL of the remote instance")
        @FormParam(value="remote-url")
        private String remoteUrl;
        @Parameter(description="User name for the remote instance. May be empty, in this case locally logged in user is assumed.")
        @FormParam(value="remote-user")
        private String remoteUserName;
        @Parameter(description="Access token for the remote instance. May be empty, in this case access token of locally logged in user is assumed.")
        @FormParam(value="remote-access-token")
        private String remoteAccessToken;
        @Parameter(description="Whether a more detailed snapshot should be created (i.e. includes which findings are present). May slow down the snapshot creation and comparison computation depending on instance size.")
        @FormParam(value="detailed-snapshot")
        private boolean detailedSnapshot;
        @Parameter(description="The branch name for which to create the instance comparison snapshot.")
        @FormParam(value="branch-name")
        private @Nullable String branchName;

        private CreateSnapshotParameters() {
        }

        public String getEndTimestampString() {
            return this.endTimestampString;
        }

        public String getProjectInclusionPattern() {
            return this.projectInclusionPattern;
        }

        public String getProjectExclusionPattern() {
            return this.projectExclusionPattern;
        }

        public String getShouldScheduleRemoteComparison() {
            return this.shouldScheduleRemoteComparison;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public String getRemoteUserName() {
            return this.remoteUserName;
        }

        public String getRemoteAccessToken() {
            return this.remoteAccessToken;
        }

        public boolean isDetailedSnapshot() {
            return this.detailedSnapshot;
        }

        public @Nullable String getBranchName() {
            return this.branchName;
        }
    }

    public record InstanceComparisonResultMetadata(int diff, int onlyInLocal, int onlyInRemote, int onlyImprovements, int withinAcceptedDeviations) {
        static InstanceComparisonResultMetadata of(InstanceComparisonResultBase result) {
            int onlyImprovements = 0;
            int withinAcceptedDeviations = 0;
            for (List diff : List.of(result.getDiffs(), result.getOnlyInLocalInstance(), result.getOnlyInRemoteInstance())) {
                for (InstanceComparisonDiffEntryBase diffEntry : diff) {
                    if (diffEntry.isOnlyImprovement()) {
                        ++onlyImprovements;
                    }
                    if (!diffEntry.isWithinAcceptedDeviations()) continue;
                    ++withinAcceptedDeviations;
                }
            }
            return new InstanceComparisonResultMetadata(result.getDiffs().size(), result.getOnlyInLocalInstance().size(), result.getOnlyInRemoteInstance().size(), onlyImprovements, withinAcceptedDeviations);
        }
    }

    public record ExternalInstanceComparisonSnapshotDto(@JsonProperty(value="name") String name, @JsonProperty(value="uploadUser") String uploadUser, @JsonProperty(value="uploadTimestamp") long uploadTimestamp, @JsonUnwrapped InstanceComparisonSnapshotDto snapshotDto) {
        public static ExternalInstanceComparisonSnapshotDto of(InstanceComparisonExternalSnapshotIndex.InstanceComparisonExternalSnapshotMetaData metaData) {
            return new ExternalInstanceComparisonSnapshotDto(metaData.name(), metaData.uploadUser(), metaData.uploadTime().toEpochMilli(), InstanceComparisonSnapshotDto.of((InstanceComparisonSnapshotMetaData)metaData.snapshotMetaData(), (InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions)InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions.EMPTY));
        }
    }
}

