/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture.dependency;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;

@Path(value="api/projects/{project}/simulink/dependencies/signals")
public class SimulinkDependencySignalsService
extends ApiBase {
    private static final String SOURCE_PARAMETER = "source";
    private static final String TARGET_PARAMETER = "target";

    @GET
    @Operation(summary="Get signals", description="Returns the list of signals for a Simulink dependency.", tags={"Architecture"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getSimulinkSignalsForDependency(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @QueryParam(value="source") @Parameter(description="Dependency source type", required=true) String source, @QueryParam(value="target") @Parameter(description="Dependency target type", required=true) String target) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ArchitectureTypeDependenciesIndex architectureTypeDependenciesIndex = this.openProjectIndex(ArchitectureTypeDependenciesIndex.class, historyAccessOption);
        Map scope = architectureTypeDependenciesIndex.getDependencyLocations();
        List locations = (List)((ListMap)scope.get(source)).getCollection((Object)target);
        ArrayList<String> signals = new ArrayList<String>();
        if (locations == null) {
            return signals;
        }
        locations.forEach(location -> {
            if (location instanceof QualifiedNameLocation) {
                QualifiedNameLocation dependencyLocation = (QualifiedNameLocation)location;
                signals.addAll(dependencyLocation.getSignalNames());
            }
        });
        return signals;
    }
}

