/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.TempFileFactory;
import com.teamscale.service.audit.ExceptionsHierarchyServiceBase;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeEdge;
import com.teamscale.service.audit.exceptions_hierarchy.ExporterExceptionsDot;
import com.teamscale.service.audit.exceptions_hierarchy.ILanguageSpecificExceptionSupport;
import com.teamscale.service.audit.exceptions_hierarchy.LanguageSpecificExceptionSupportFactory;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.graph.EGraphvizOutputFormat;
import org.conqat.lib.commons.graph.GraphvizException;
import org.conqat.lib.commons.graph.GraphvizGenerator;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Path(value="api/projects/{project}/exceptions-hierarchy/graph")
public class DotExceptionsHierarchyService
extends ExceptionsHierarchyServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME_GRAPHVIZ_FORMAT = "isdot";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get hierarchies of custom exceptions", description="Retrieves hierarchies of custom exceptions represented graphically.", tags={"Audit"})
    public List<String> getExceptionsHierarchyTreeSVG(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Whether the DOT format is expected.") @QueryParam(value="isdot") boolean isDotFormatRequired) throws StorageException {
        Set<ELanguage> projectLanguages = this.getProjectLanguages(commit);
        ArrayList<String> hierarchies = new ArrayList<String>();
        for (ELanguage language : projectLanguages) {
            String hierarchyForLanguage = this.processLanguage(language);
            hierarchies.add(hierarchyForLanguage);
        }
        ArrayList<String> svgHierarchies = new ArrayList<String>();
        if (isDotFormatRequired) {
            return hierarchies;
        }
        for (String dotHierarchy : hierarchies) {
            Optional<String> svgHierarchy = DotExceptionsHierarchyService.convertDotToSvg(dotHierarchy);
            svgHierarchy.ifPresent(svgHierarchies::add);
        }
        return svgHierarchies;
    }

    private String processLanguage(ELanguage language) throws StorageException {
        Optional<ILanguageSpecificExceptionSupport> languageSupport = LanguageSpecificExceptionSupportFactory.getForLanguage(language);
        if (languageSupport.isEmpty()) {
            LOGGER.warn("Exception hierarchy analysis is not implemented for language {}", (Object)language.getReadableName());
            return "";
        }
        ExporterExceptionsDot dotExceptionExporter = new ExporterExceptionsDot(languageSupport.get());
        List<ExceptionsTreeEdge> edges = this.getExceptionTreeEdgesFromProject(language);
        return dotExceptionExporter.exportExceptionsHierarchy(edges);
    }

    private static Optional<String> convertDotToSvg(String hierarchyForLanguage) {
        try {
            TempFileFactory tempFactory = new TempFileFactory(FileSystemUtils.getTmpDir());
            CanonicalFile svgFile = tempFactory.getTempFile("exceptions", "svg");
            new GraphvizGenerator().generateFile(hierarchyForLanguage, (File)svgFile, EGraphvizOutputFormat.SVG);
            String svgString = XMLUtils.print((Document)XMLUtils.parse((File)svgFile));
            svgFile.delete();
            return Optional.of(svgString);
        }
        catch (IOException | TransformerException | GraphvizException | SAXException e) {
            LOGGER.error("DOT exception while printing the exception hierarchy ", e);
            return Optional.empty();
        }
    }
}

