/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.badge.velocity.metric;

import com.teamscale.service.badge.velocity.Segment;
import com.teamscale.service.framework.badge.SvgUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class MetricBadgeSegment
extends Segment {
    private final double metricAssessmentIconWidth;
    private final double metricAssessmentIconStart;
    private double redMetricIconWidth = 0.0;
    private double yellowMetricIconWidth = 0.0;
    private double greenMetricIconWidth = 0.0;
    private double redMetricIconStart = 0.0;
    private double yellowMetricIconStart = 0.0;
    private double greenMetricIconStart = 0.0;

    public MetricBadgeSegment(String text, String tooltip, String color, double segmentStart) {
        super(text, tooltip, color, segmentStart);
        this.metricAssessmentIconStart = 0.0;
        this.metricAssessmentIconWidth = 0.0;
    }

    public MetricBadgeSegment(String text, String tooltip, String color, double segmentStart, ETrafficLightColor metricAssessmentColor, double metricAssessmentIconStart) {
        super(text, tooltip, color, segmentStart, (double)SvgUtils.computeTextWidth((String)text) + 6.0 * MetricBadgeSegment.getMargin());
        if (metricAssessmentColor == ETrafficLightColor.UNKNOWN || metricAssessmentColor == ETrafficLightColor.BASELINE) {
            this.metricAssessmentIconStart = 0.0;
            this.metricAssessmentIconWidth = 0.0;
        } else {
            this.metricAssessmentIconStart = metricAssessmentIconStart;
            this.metricAssessmentIconWidth = 23.0;
            this.setMetricAssessmentIconStartAndWidth(metricAssessmentColor, metricAssessmentIconStart);
        }
    }

    @Override
    public double getSegmentWidth() {
        return super.getSegmentWidth() + this.metricAssessmentIconWidth;
    }

    private void setMetricAssessmentIconStartAndWidth(ETrafficLightColor icon, double iconStart) {
        switch (icon) {
            case RED: {
                this.redMetricIconWidth = 15.0;
                this.redMetricIconStart = iconStart + 4.0;
                break;
            }
            case YELLOW: 
            case ORANGE: {
                this.yellowMetricIconWidth = 15.0;
                this.yellowMetricIconStart = iconStart + 4.0;
                break;
            }
            case GREEN: {
                this.greenMetricIconWidth = 15.0;
                this.greenMetricIconStart = iconStart + 4.0;
                break;
            }
        }
    }

    public double getMetricAssessmentIconStart() {
        return this.metricAssessmentIconStart;
    }

    public double getMetricAssessmentIconWidth() {
        return this.metricAssessmentIconWidth;
    }

    public double getRedMetricIconWidth() {
        return this.redMetricIconWidth;
    }

    public double getYellowMetricIconWidth() {
        return this.yellowMetricIconWidth;
    }

    public double getGreenMetricIconWidth() {
        return this.greenMetricIconWidth;
    }

    public double getRedMetricIconStart() {
        return this.redMetricIconStart;
    }

    public double getYellowMetricIconStart() {
        return this.yellowMetricIconStart;
    }

    public double getGreenMetricIconStart() {
        return this.greenMetricIconStart;
    }
}

