/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.badge.velocity.metric;

import com.teamscale.service.badge.velocity.BadgeData;
import com.teamscale.service.badge.velocity.metric.MetricGroupBadgeSegment;
import com.teamscale.service.merge_request.metrics.EMetricTrendColor;

public class MetricGroupBadgeData
extends BadgeData {
    private static final String NO_DATA_ICON_NAME = "icon-question-circle";
    private static final String CARET_DOWN_ICON_NAME = "icon-square-caret-down";
    private static final String STABLE_METRICS_ICON_NAME = "icon-square-caret-left";
    private static final String CARET_UP_ICON_NAME = "icon-square-caret-up";
    private static final String THRESHOLD_VIOLATION_ICON_NAME = "icon-bell";
    private final boolean increasingValuesIndicateImprovement;

    public MetricGroupBadgeData(boolean increasingValuesIndicateImprovement) {
        this.increasingValuesIndicateImprovement = increasingValuesIndicateImprovement;
    }

    @Override
    public void appendTitle(String text, String tooltip) {
        this.segments.add(new MetricGroupBadgeSegment(text, tooltip, "#555", this.getFullWidth()));
    }

    @Override
    public void appendSegment(String text, String tooltip, String color) {
        this.segments.add(new MetricGroupBadgeSegment(text, tooltip, color, this.getFullWidth()));
    }

    @Override
    public void appendSegment(String text, String color) {
        this.appendSegment(text, "", color);
    }

    public void appendSegmentForMetricsWithoutData(String text) {
        this.segments.add(new MetricGroupBadgeSegment(text, "metrics without data: " + text, EMetricTrendColor.UNKNOWN_BADGE.getHexValue(false), this.getFullWidth(), NO_DATA_ICON_NAME));
    }

    public void appendSegmentForDeterioratedMetrics(String text) {
        String iconName = this.increasingValuesIndicateImprovement ? CARET_DOWN_ICON_NAME : CARET_UP_ICON_NAME;
        this.segments.add(new MetricGroupBadgeSegment(text, "deteriorated metrics: " + text, EMetricTrendColor.NEGATIVE.getHexValue(false), this.getFullWidth(), iconName));
    }

    public void appendSegmentForStableMetrics(String text) {
        this.segments.add(new MetricGroupBadgeSegment(text, "stable metrics: " + text, EMetricTrendColor.NEUTRAL_TREEMAP.getHexValue(false), this.getFullWidth(), STABLE_METRICS_ICON_NAME));
    }

    public void appendSegmentForImprovedMetrics(String text) {
        String iconName = this.increasingValuesIndicateImprovement ? CARET_UP_ICON_NAME : CARET_DOWN_ICON_NAME;
        this.segments.add(new MetricGroupBadgeSegment(text, "improved metrics: " + text, EMetricTrendColor.POSITIVE.getHexValue(false), this.getFullWidth(), iconName));
    }

    public void appendSegmentForThresholdViolations(String text) {
        this.segments.add(new MetricGroupBadgeSegment(text, "new threshold violations: " + text, EMetricTrendColor.ALERT_BADGE.getHexValue(false), this.getFullWidth(), THRESHOLD_VIOLATION_ICON_NAME));
    }
}

