/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.index.dashboard.templates.DashboardTemplateDescriptor;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dashboard.DashboardService;
import com.teamscale.service.dashboard.DashboardTemplateService;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.persistence.store.StorageException;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/dashboards")
public class LegacyDashboardService
extends ApiBase {
    private static final String PARAM_DASHBOARD_DESCRIPTOR = "dashboardDescriptor";
    @Context
    private ResourceContext resourceContext;

    @POST
    @RequiresNoPermission
    @PublicApi(since=ETeamscaleVersion.VERSION_5_8_0, deprecatedSince=ETeamscaleVersion.VERSION_8_7_0)
    @Operation(summary="Post a dashboard or a dashboard template", description="Performs an import of a dashboard or a dashboard template. Redirects to the templates overview page or the last edited dashboard. Adds the uploaded descriptor to the list of dashboards/templates. The descriptor must be packaged within an XML Teamscale Version Container.", parameters={@Parameter(name="dashboardDescriptor", description="Dashboard/template description", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamscaleVersionContainer.class))})}, tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No descriptor data given.")})
    @Consumes(value={"multipart/form-data"})
    public List<String> importDashboard(@Parameter(required=true) @ArraySchema(schema=@Schema(type="string", format="binary")) @FormDataParam(value="dashboardDescriptor") List<String> dashboardDescriptors) throws StorageException, MigrationException {
        ArrayList<String> importedFiles = new ArrayList<String>();
        for (String content : dashboardDescriptors) {
            List<UUID> uuids;
            Optional type = TeamscaleVersionContainer.extractType((String)content);
            if (type.isPresent() && ((String)type.get()).equals(DashboardTemplateDescriptor.class.getSimpleName())) {
                uuids = ((DashboardTemplateService)this.resourceContext.getResource(DashboardTemplateService.class)).importDashboardTemplate(List.of(content));
                importedFiles.add(String.valueOf(uuids.get(0)) + ".tstemplate");
                continue;
            }
            uuids = ((DashboardService)this.resourceContext.getResource(DashboardService.class)).importDashboard(List.of(content));
            importedFiles.add(String.valueOf(uuids.get(0)) + ".tsdashboard");
        }
        return importedFiles;
    }
}

