/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.BasicFindingFilterUtils;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.EBlacklistingOption;
import com.teamscale.index.findings.calculation.EPendingExclusionOption;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.findings.FlaggedFindingsService;
import jakarta.ws.rs.container.ResourceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ExcludedFindingsUtils {
    public static ExcludedFindingsDelta getExcludedFindingsDelta(@Nullable String mergeBaseKey, UniformPath uniformPath, TimeRange timeRange, BasicFindingsFilterSettings filterSettings, ResourceContext resourceContext, FindingsCalculationInfo calculationInfo) throws StorageException {
        Map<String, FindingBlacklistInfo> excludedFindingInfos = ((FlaggedFindingsService)resourceContext.getResource(FlaggedFindingsService.class)).getFlaggedFindings(mergeBaseKey, timeRange.start().toUnresolvedCommitDescriptor(), timeRange.end().toUnresolvedCommitDescriptor(), filterSettings.isOnlySpecItemFindings()).stream().collect(Collectors.toMap(FindingBlacklistInfo::getFindingId, Function.identity()));
        List<TrackedFinding> excludedFindings = ExcludedFindingsUtils.retrieveFilteredExcludedFindings(excludedFindingInfos, mergeBaseKey, filterSettings.isOnlySpecItemFindings(), uniformPath, timeRange, calculationInfo);
        List extendedExcludedFindings = ExtendedTrackedFindingUtils.fromTrackedFindings(excludedFindings, (FindingsCalculationInfo)calculationInfo, excludedFindingInfos);
        ArrayList<ExtendedTrackedFinding> toleratedFindings = new ArrayList<ExtendedTrackedFinding>();
        ArrayList<ExtendedTrackedFinding> pendingToleratedFindings = new ArrayList<ExtendedTrackedFinding>();
        ArrayList<ExtendedTrackedFinding> falsePositiveFindings = new ArrayList<ExtendedTrackedFinding>();
        ArrayList<ExtendedTrackedFinding> pendingFalsePositiveFindings = new ArrayList<ExtendedTrackedFinding>();
        ExcludedFindingsUtils.distributeExcludedFindingsByType(extendedExcludedFindings, toleratedFindings, pendingToleratedFindings, falsePositiveFindings, pendingFalsePositiveFindings);
        filterSettings.setBlacklistingOption(EBlacklistingOption.ALL);
        filterSettings.setPendingExclusionOption(EPendingExclusionOption.ALL);
        FilteredFindingsList filteredTolerated = BasicFindingFilterUtils.filterFindings(toleratedFindings, (BasicFindingsFilterSettings)filterSettings, (FindingsCalculationInfo)calculationInfo);
        FilteredFindingsList filteredPendingTolerated = BasicFindingFilterUtils.filterFindings(pendingToleratedFindings, (BasicFindingsFilterSettings)filterSettings, (FindingsCalculationInfo)calculationInfo);
        FilteredFindingsList filteredFalsePositiveFindings = BasicFindingFilterUtils.filterFindings(falsePositiveFindings, (BasicFindingsFilterSettings)filterSettings, (FindingsCalculationInfo)calculationInfo);
        FilteredFindingsList filteredPendingFalsePositiveFindings = BasicFindingFilterUtils.filterFindings(pendingFalsePositiveFindings, (BasicFindingsFilterSettings)filterSettings, (FindingsCalculationInfo)calculationInfo);
        return new ExcludedFindingsDelta(filteredTolerated, filteredPendingTolerated, filteredFalsePositiveFindings, filteredPendingFalsePositiveFindings);
    }

    private static List<TrackedFinding> retrieveFilteredExcludedFindings(Map<String, FindingBlacklistInfo> findingBlacklistInfos, String mergeBaseKey, boolean onlySpecItemFindings, UniformPath uniformPath, TimeRange resolvedRange, FindingsCalculationInfo calculationInfo) throws StorageException {
        ArrayList<String> flaggedFindingIds = new ArrayList<String>(findingBlacklistInfos.keySet());
        IFindingsRetriever findingsRetriever = IFindingsRetriever.getFindingsRetriever((boolean)onlySpecItemFindings, (boolean)false, (String)resolvedRange.end().getBranchName(), (FindingsCalculationInfo)calculationInfo);
        List flaggedFindings = CollectionUtils.filter((Collection)findingsRetriever.getFindings(flaggedFindingIds, resolvedRange.end()), Objects::nonNull);
        if (mergeBaseKey != null) {
            findingsRetriever = IFindingsRetriever.getFindingsRetriever((boolean)onlySpecItemFindings, (boolean)false, (String)resolvedRange.start().getBranchName(), (FindingsCalculationInfo)calculationInfo);
            HashSet remainingFindingIds = CollectionUtils.differenceSet(flaggedFindingIds, (Collection[])new Collection[]{CollectionUtils.map((Collection)flaggedFindings, TrackedFinding::getId)});
            flaggedFindings.addAll(CollectionUtils.filter((Collection)findingsRetriever.getFindings(new ArrayList(remainingFindingIds), resolvedRange.start()), Objects::nonNull));
        }
        Predicate<UniformPath> pathPredicate = ExcludedFindingsUtils.isIncludedInTree(uniformPath, resolvedRange, calculationInfo);
        return flaggedFindings.stream().filter(finding -> pathPredicate.test(UniformPathCompatibilityUtil.convert((String)finding.getLocation().getUniformPath()))).toList();
    }

    private static Predicate<UniformPath> isIncludedInTree(UniformPath uniformPath, TimeRange resolvedRange, FindingsCalculationInfo calculationInfo) throws StorageException {
        Set resolvedPaths = switch (uniformPath.getType()) {
            default -> throw new MatchException(null, null);
            case UniformPath.EType.SPEC_ITEM, UniformPath.EType.CODE -> Set.of(uniformPath);
            case UniformPath.EType.ARCHITECTURE, UniformPath.EType.CODE_SCOPES -> VirtualCodePathUtils.resolveToCodePaths((UniformPath)uniformPath, (ProjectStorageSystem)calculationInfo.projectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readCommit((CommitDescriptor)resolvedRange.end()));
            case UniformPath.EType.NON_CODE, UniformPath.EType.TEST_IMPLEMENTATION, UniformPath.EType.TEST_EXECUTION, UniformPath.EType.ISSUE_ITEM, UniformPath.EType.TEST_QUERY, UniformPath.EType.ISSUE_QUERY, UniformPath.EType.SPEC_ITEM_QUERY, UniformPath.EType.EXECUTION_UNIT -> throw new IllegalArgumentException("Cannot retrieve findings for path: " + String.valueOf(uniformPath));
        };
        return VirtualCodePathUtils.isIncludedInTree(resolvedPaths);
    }

    private static void distributeExcludedFindingsByType(List<ExtendedTrackedFinding> flaggedFindings, List<ExtendedTrackedFinding> toleratedFindings, List<ExtendedTrackedFinding> pendingToleratedFindings, List<ExtendedTrackedFinding> falsePositiveFindings, List<ExtendedTrackedFinding> pendingFalsePositiveFindings) {
        block4: for (ExtendedTrackedFinding extendedFlaggedFinding : flaggedFindings) {
            Optional findingBlacklistInfo = extendedFlaggedFinding.getBlacklistInfo();
            if (findingBlacklistInfo.isEmpty() || ((FindingBlacklistInfo)findingBlacklistInfo.get()).getType() == null) continue;
            switch (((FindingBlacklistInfo)findingBlacklistInfo.get()).getType()) {
                case TOLERATION: {
                    if (((FindingBlacklistInfo)findingBlacklistInfo.get()).getApprovalState().resolved()) {
                        toleratedFindings.add(extendedFlaggedFinding);
                        continue block4;
                    }
                    pendingToleratedFindings.add(extendedFlaggedFinding);
                    continue block4;
                }
                case FALSE_POSITIVE: {
                    if (((FindingBlacklistInfo)findingBlacklistInfo.get()).getApprovalState().resolved()) {
                        falsePositiveFindings.add(extendedFlaggedFinding);
                        continue block4;
                    }
                    pendingFalsePositiveFindings.add(extendedFlaggedFinding);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected EFindingBlacklistType: " + String.valueOf(((FindingBlacklistInfo)findingBlacklistInfo.get()).getType()));
        }
    }

    private ExcludedFindingsUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public record ExcludedFindingsDelta(FilteredFindingsList toleratedFindings, FilteredFindingsList pendingToleratedFindings, FilteredFindingsList falsePositiveFindings, FilteredFindingsList pendingFalsePositiveFindings) {
    }
}

