/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.scenario.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.scenario.FindingTrackingTestScenario;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/findings/debug/finding-tracking-test-data")
public class FindingTrackingTestDataService
extends ApiBase {
    @Operation(summary="Get findings tracking scenario", description="Returns the tracking scenario derived from the revision specified via the t parameter.")
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public FindingTrackingTestScenario getScenario(@QueryParam(value="t") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        RepositoryLogFileIndex logFileIndex = this.openProjectIndex(RepositoryLogFileIndex.class, null);
        List logEntries = logFileIndex.getEntriesByCommit(commit);
        if (CollectionUtils.isNullOrEmpty((Collection)logEntries)) {
            throw new BadRequestException("No log entries found for commit: " + String.valueOf(commit));
        }
        ParentedCommitDescriptor parentedCommit = this.openCommitDescriptorIndex().getCommit(commit);
        if (parentedCommit == null || parentedCommit.getFirstParentCommit() == null) {
            throw new BadRequestException("Selected commit without parent commit!");
        }
        TokenElementIndex newContentIndex = this.openTokenElementIndex(commit);
        TrackedFindingsIndex newFindingIndex = this.openTrackedFindingsIndex(commit);
        ArrayList<TokenElementIndex> oldContentIndexes = new ArrayList<TokenElementIndex>();
        ArrayList<TrackedFindingsIndex> oldFindingsIndexes = new ArrayList<TrackedFindingsIndex>();
        for (CommitDescriptor parent : parentedCommit.getParentCommits()) {
            oldContentIndexes.add(this.openTokenElementIndex(parent));
            oldFindingsIndexes.add(this.openTrackedFindingsIndex(parent));
        }
        return FindingTrackingTestDataService.buildScenario(logEntries, newContentIndex, oldContentIndexes, newFindingIndex, oldFindingsIndexes);
    }

    private TrackedFindingsIndex openTrackedFindingsIndex(CommitDescriptor commit) throws StorageException {
        return this.openProjectIndex(TrackedFindingsIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
    }

    private TokenElementIndex openTokenElementIndex(CommitDescriptor commit) throws StorageException {
        return TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
    }

    private static FindingTrackingTestScenario buildScenario(List<RepositoryLogFileEntry> logEntries, TokenElementIndex newContentIndex, List<TokenElementIndex> oldContentIndexes, TrackedFindingsIndex newFindingIndex, List<TrackedFindingsIndex> oldFindingIndexes) throws StorageException {
        FindingTrackingTestScenario scenario = new FindingTrackingTestScenario(oldContentIndexes.size());
        for (RepositoryLogFileEntry logEntry : logEntries) {
            String uniformPath = logEntry.getUniformPath().toStringAsMigrationFrontier();
            for (int i = 0; i < oldContentIndexes.size(); ++i) {
                TokenElementInfo oldContent = oldContentIndexes.get(i).getTokenElement(uniformPath);
                FindingTrackingTestDataService.addOldFile(oldFindingIndexes, scenario, uniformPath, i, oldContent, oldContentIndexes.size());
            }
            if (logEntry.isDeleted()) continue;
            scenario.addNewFile(newContentIndex.getTokenElement(uniformPath), newFindingIndex.getFindings(uniformPath));
        }
        return scenario;
    }

    private static void addOldFile(List<TrackedFindingsIndex> oldFindingIndexes, FindingTrackingTestScenario scenario, String uniformPath, int parentNumber, TokenElementInfo oldContent, int oldContentIndexesSize) throws StorageException {
        if (oldContent == null) {
            if (oldContentIndexesSize == 1) {
                throw new StorageException("No old content found for " + uniformPath);
            }
            return;
        }
        scenario.addOldFile(oldContent, oldFindingIndexes.get(parentNumber).getFindings(uniformPath), parentNumber);
    }
}

