/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.issues.model.UserResolvedTeamscaleIssue;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.issues.IssueFilterUtils;
import com.teamscale.service.issues.QueryServiceBase;
import com.teamscale.service.issues.TeamscaleUserAliasResolver;
import com.teamscale.wia.TeamscaleIssue;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.AutocompletionResult;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/issue-query")
public class IssueQueryService
extends QueryServiceBase {
    @GET
    @Operation(summary="Perform issue query", description="Retrieves the size and list of issues for the query.", tags={"Issues", "Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryServiceBase.QueryParserFailure.class))}, description="Could not process query.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public QueryServiceBase.IssueQueryResult<UserResolvedTeamscaleIssue> performIssueQuery(@QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Issue query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @BeanParam SortAndPaginationOptions parameters) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)this.resolve(commit));
        WorkItemHistoryIndexAggregation indexAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        List<TeamscaleIssue> issues = this.performIssueQuery(query, (IKeyedObjectIndex<TeamscaleIssue>)indexAggregation, historyAccessOption);
        int actualResultSize = issues.size();
        issues = IssueFilterUtils.applyFiltersAndPagination(issues, parameters, indexAggregation.getDescriber());
        List<UserResolvedTeamscaleIssue> userResolvedIssues = this.getUserResolvedIssues(issues);
        return QueryServiceBase.IssueQueryResult.of(actualResultSize, userResolvedIssues, parameters.getNextStartIndex());
    }

    @GET
    @Path(value="trend")
    @Operation(summary="Perform issue trend query", description="Retrieves the issue trend for the query.", tags={"Issues"}, responses={@ApiResponse(responseCode="400", description="Could not process query.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public QueryTrendResult getIssueQueryTrend(@QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Issue query") @QueryParam(value="query") @DefaultValue(value="") String query) throws StorageException {
        CommitDescriptor resolved = this.resolve(commit);
        WorkItemHistoryIndexAggregation indexAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)resolved);
        return new QueryTrendResult(this.getTrend((IKeyedObjectIndex<TeamscaleIssue>)indexAggregation, query, resolved.getBranchName()));
    }

    @GET
    @Path(value="trend/download")
    @Operation(summary="Get issue trend", description="Downloads issue trend data.", tags={"Issues"}, responses={@ApiResponse(responseCode="400", description="Could not process query.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/csv"})
    public Response getIssueTrendAsCsv(@QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Issue query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query) throws StorageException {
        CommitDescriptor resolved = this.resolve(commit);
        WorkItemHistoryIndexAggregation indexAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)resolved);
        PairList<Long, Double> trend = this.getTrend((IKeyedObjectIndex<TeamscaleIssue>)indexAggregation, query, resolved.getBranchName());
        String entity = CsvServiceUtils.createCsvString(csvListWriter -> IssueQueryService.sendIssueTrendDataToCsvWriter(trend, csvListWriter));
        String fileName = String.valueOf(this.serviceInfo.getPrimaryPublicId()) + "-issue-query-result.csv";
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)fileName);
    }

    @GET
    @Path(value="validation")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Validate issue query", description="Decided whether an issue query is valid", tags={"Issues"})
    public boolean isIssueQueryValid(@Parameter(description="Issue query to validate", required=true, allowEmptyValue=true) @QueryParam(value="query") String queryTerm) throws StorageException {
        return this.validateQuery(queryTerm, StoredQueryIndex.EStoredQueryType.ISSUE);
    }

    @GET
    @Path(value="columns")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get available column names", description="Returns the names of all columns that are available for issue entities", tags={"Issues"})
    public Map<String, EKeyedObjectType> getKnownIssueQueryColumns(@QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        return WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)this.resolve(commit)).getKnownColumns().toMap();
    }

    @GET
    @Path(value="autocomplete")
    @Operation(summary="Get autocompletion suggestions", description="Retrieves a list of autocompletion suggestions for the given query", tags={"Issues"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public AutocompletionResult getIssueQueryAutocompletionSuggestions(@QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Token to generate autocompletion< suggestions for", required=true, allowEmptyValue=true) @QueryParam(value="token") String queryTerm) throws StorageException {
        return this.getAutocompletionSuggestions((IKeyedObjectIndex<?>)WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (CommitDescriptor)this.resolve(commit)), queryTerm, StoredQueryIndex.EStoredQueryType.ISSUE);
    }

    private PairList<Long, Double> getTrend(IKeyedObjectIndex<TeamscaleIssue> historyIndex, String queryString, String branch) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.serviceInfo.getProjectStorageSystem();
        return QueryableEntityUtils.getIssueTrend(historyIndex, (String)queryString, (QueryableEntityUtils.QueryContext)QueryableEntityUtils.QueryContext.ofTrend((ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem(), (User)this.serviceInfo.getUser(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE, (long)0L, (long)System.currentTimeMillis(), (String)branch));
    }

    private List<UserResolvedTeamscaleIssue> getUserResolvedIssues(List<TeamscaleIssue> issues) throws StorageException {
        TeamscaleUserAliasResolver resolver = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        return UserResolvedTeamscaleIssue.of(issues, resolver.resolveIssues(issues));
    }

    private static void sendIssueTrendDataToCsvWriter(PairList<Long, Double> trendList, CsvListWriter csvListWriter) throws IOException {
        csvListWriter.writeHeader(new String[]{"date", "issue-count"});
        SimpleDateFormat dateOnlyFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        for (Pair entry : trendList) {
            csvListWriter.write(new Object[]{dateOnlyFormat.format(entry.getFirst()), ((Double)entry.getSecond()).intValue()});
        }
    }

    private static class QueryTrendResult {
        @JsonProperty(value="trendTimestamps")
        private final List<Long> trendTimestamps = new ArrayList<Long>();
        @JsonProperty(value="trendValues")
        private final List<Double> trendValues = new ArrayList<Double>();

        private QueryTrendResult(PairList<Long, Double> trend) {
            for (int i = 0; i < trend.size(); ++i) {
                this.trendTimestamps.add((Long)trend.getFirst(i));
                this.trendValues.add((Double)trend.getSecond(i));
            }
        }
    }
}

