/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.base.RepositoryToTriggerMappingIndex;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/merge-requests/debug/repository-trigger-mapping-index")
public class DebugRepositoryToTriggerMappingIndexService
extends DebugDumpServiceBase {
    @GET
    @Operation(summary="Get repository to trigger mappings", description="Returns all the mappings of repositories to triggers for the given project.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getRepositoryToTriggerMappings() throws StorageException {
        return this.getDebugDumpResults();
    }

    @DELETE
    @Path(value="{repositoryName}/{triggerName}")
    @Operation(summary="Deletes the mapping corresponding to the provided repository name/URL and trigger name", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void deleteRepositoryToTriggerMapping(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="triggerName") String triggerName) throws StorageException {
        RepositoryToTriggerMappingIndex repositoryToTriggerMappingIndex = this.openProjectIndex(RepositoryToTriggerMappingIndex.class, null);
        repositoryToTriggerMappingIndex.removeMapping(repositoryName, triggerName);
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        RepositoryToTriggerMappingIndex repositoryToTriggerMappingIndex = this.openProjectIndex(RepositoryToTriggerMappingIndex.class, null);
        PairList allMappings = repositoryToTriggerMappingIndex.getAllMappings();
        allMappings.forEach(entry -> {
            writer.print((String)entry.getFirst());
            writer.print(": ");
            writer.println((String)entry.getSecond());
        });
    }
}

