/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.force_vote.strategy;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.gerrit.GerritAnalysisResultUploadTrigger;
import com.teamscale.index.repository.git.gerrit.GerritRestClient;
import com.teamscale.index.repository.git.gerrit.GerritUtils;
import com.teamscale.index.repository.git.gerrit.data.ChangeInfo;
import com.teamscale.service.merge_request.force_vote.strategy.IMergeRequestForceVoteStrategy;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GerritMergeRequestVoteStrategy
implements IMergeRequestForceVoteStrategy {
    private final InternalProjectId projectId;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private final RepositoryLogIndex repositoryLogIndex;
    private final RepositoryRevisionIndex repositoryRevisionIndex;
    private final IndexLayer indexLayer;
    private final Logger logger;

    public GerritMergeRequestVoteStrategy(InternalProjectId projectId, CommitDescriptorIndex commitDescriptorIndex, RepositoryLogIndex repositoryLogIndex, RepositoryRevisionIndex repositoryRevisionIndex, IndexLayer indexLayer, Logger logger) {
        this.projectId = projectId;
        this.commitDescriptorIndex = commitDescriptorIndex;
        this.repositoryLogIndex = repositoryLogIndex;
        this.repositoryRevisionIndex = repositoryRevisionIndex;
        this.indexLayer = indexLayer;
        this.logger = logger;
    }

    @Override
    public void forceVoteOnMergeRequests(List<MergeRequest> mergeRequests, ConnectorConfiguration connectorConfiguration) throws StorageException {
        Set ids = CollectionUtils.mapToSet(mergeRequests, MergeRequest::getId);
        this.revoteOnGerritVotingConnector(connectorConfiguration, changeInfo -> ids.contains(changeInfo.getNumber()));
    }

    private void revoteOnGerritVotingConnector(ConnectorConfiguration gerritConnector, Predicate<ChangeInfo> changeFilter) throws StorageException, BadRequestException {
        Optional accountCredentialsOption = GerritAnalysisResultUploadTrigger.getGerritAccountCredentials((ConnectorConfiguration)gerritConnector, (IndexLayer)this.indexLayer);
        if (accountCredentialsOption.isEmpty()) {
            String errorMessage = "Could not found account credentials used in connector: " + String.valueOf(gerritConnector) + ". Skipping.";
            this.logger.error(errorMessage);
            return;
        }
        ExternalCredentials externalCredentials = (ExternalCredentials)accountCredentialsOption.get();
        List<ChangeInfo> openChanges = GerritMergeRequestVoteStrategy.retrieveOpenChanges(gerritConnector, GerritMergeRequestVoteStrategy.createGerritRestClient(gerritConnector, externalCredentials));
        List openChangesToVoteOn = CollectionUtils.filter(openChanges, changeFilter);
        this.revoteOpenChanges(openChangesToVoteOn);
    }

    private static GerritRestClient createGerritRestClient(ConnectorConfiguration gerritConnector, ExternalCredentials externalCredentials) {
        return new GerritRestClient(externalCredentials.uri, externalCredentials.username, externalCredentials.password, Collections.emptyList(), 360, GerritAnalysisResultUploadTrigger.getRestClientAuthenticationMode((ConnectorConfiguration)gerritConnector));
    }

    private static List<ChangeInfo> retrieveOpenChanges(ConnectorConfiguration gerritConnector, GerritRestClient client) throws BadRequestException {
        String startRevision = gerritConnector.getOptionValue("Start revision");
        Optional startDate = ConnectorUtils.parseDate((String)startRevision);
        if (startDate.isEmpty()) {
            throw new BadRequestException("Connector " + gerritConnector.getIdentifier() + " has a startRevision that cannot be parsed to date: " + startRevision);
        }
        try {
            return client.getOpenChangesAfter(gerritConnector.getOptionValue("Project Name"), (ZonedDateTime)startDate.get());
        }
        catch (ServiceCallException e) {
            throw new ServerErrorException("Could not query open changes for connector " + gerritConnector.getIdentifier(), Response.Status.BAD_GATEWAY, (Throwable)e);
        }
    }

    private void revoteOpenChanges(List<ChangeInfo> openChanges) throws StorageException {
        for (ChangeInfo changeInfo : openChanges) {
            if (changeInfo.getRevisions().isEmpty()) continue;
            Map.Entry revEntry = changeInfo.getRevisions().entrySet().iterator().next();
            Optional commit = this.repositoryRevisionIndex.getFirstProcessedCommit((String)revEntry.getKey());
            if (commit.isEmpty() || !GerritUtils.isGerritBranch((String)((CommitDescriptor)commit.get()).getBranchName())) {
                this.logger.atWarn().log("Found open change whose most recent commit is not a Gerrit branch in Teamscale: {}. Skipping...", revEntry.getKey());
                continue;
            }
            String branchName = ((CommitDescriptor)commit.get()).getBranchName();
            Optional schedulingCommit = GerritUtils.getLastRealCommitOnBranch((List)this.commitDescriptorIndex.getCommitsForBranch(branchName), (RepositoryLogIndex)this.repositoryLogIndex);
            if (schedulingCommit.isEmpty()) {
                this.logger.atError().log("Could not find viable commit on branch of: {}", (Object)schedulingCommit);
                continue;
            }
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.indexLayer, new JobDescriptor(this.projectId, GerritAnalysisResultUploadTrigger.class, (CommitDescriptor)schedulingCommit.get(), "Forced re-vote by user."));
        }
    }
}

