/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.ProjectRole;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/roles/project-roles")
public class ProjectRolesService
extends ApiBase {
    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_ROLES})
    @Operation(summary="Create project role", description="Creates a new project role.", tags={"Permission"})
    public void postProjectRole(@RequestBody(required=true) ProjectRole updatedRole) throws StorageException {
        this.getPermissions().createPermissionModifier().setProjectRole(updatedRole, "");
    }

    @PUT
    @Path(value="{name}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_ROLES})
    @Operation(summary="Update project role", description="Updates/renames an existing project role. Or creates it as a new role if the parameter for the old global role name is null or an empty string.", tags={"Permission"})
    public void putProjectRole(@RequestBody(required=true) ProjectRole updatedRole, @Parameter(description="The name of the role to update/rename.") @PathParam(value="name") String oldRoleName) throws StorageException {
        this.getPermissions().createPermissionModifier().setProjectRole(updatedRole, oldRoleName);
    }

    @DELETE
    @Path(value="{name}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_ROLES})
    @Operation(summary="Delete project role", description="Removes an existing project role.", tags={"Permission"})
    public void deleteProjectRole(@Parameter(description="The name of the role to delete.") @PathParam(value="name") String roleName) throws StorageException {
        this.getPermissions().createPermissionModifier().removeProjectRole(roleName);
    }
}

