/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.persistence;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.statistics.StatisticsCollectingCallback;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/store-overview")
public class StoreSizeOverviewService
extends ApiBase {
    @GET
    @Operation(summary="Get store size overview", description="Returns a textual overview of the size of all stores", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    public String getStoreSizeOverview() throws StorageException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("Global storage: " + StoreSizeOverviewService.formatByteCount(StoreSizeOverviewService.getStorageSystemSize((SchemaAwareStorageSystem)this.getGlobalStorageSystem())));
        writer.println();
        List projects = this.getPermissions().getVisibleProjects();
        writer.println("Projects");
        for (ProjectInfo project : projects) {
            CommitResolvingStorageSystem projectStorageSystem = this.getIndexLayer().openProjectStorageSystem(project);
            writer.println("   " + String.valueOf(project.getPrimaryPublicId()) + ": " + StoreSizeOverviewService.formatByteCount(StoreSizeOverviewService.getStorageSystemSize((SchemaAwareStorageSystem)projectStorageSystem)));
        }
        writer.close();
        return stringWriter.toString();
    }

    private static String formatByteCount(long bytes) {
        return NumberFormat.getIntegerInstance(Locale.US).format(bytes) + " bytes";
    }

    private static long getStorageSystemSize(SchemaAwareStorageSystem storageSystem) throws StorageException {
        StatisticsCollectingCallback callback = new StatisticsCollectingCallback();
        for (String storeName : CollectionUtils.sort((Collection)storageSystem.getSchema().getEntryNames())) {
            IStore store = storageSystem.openStore(storeName);
            store.scan(new byte[0], (IKeyValueCallback)callback);
        }
        return callback.getKeySize() + callback.getValueSize();
    }
}

