/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.persistence;

import com.teamscale.service.base.ApiBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.statistics.StatisticsCollectingCallback;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class StoreStatisticsServiceBase
extends ApiBase {
    protected static final String STORE_PARAMETER_DESCRIPTION = "If set, only the store with the given name is included. By default, all stores will be included.";

    protected String getStoreSizeStatistics(SchemaAwareStorageSystem storageSystem, @Nullable String targetStoreName) throws StorageException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("Name;" + StatisticsCollectingCallback.CSV_HEADER);
        Object storeNames = storageSystem.getSchema().getEntryNames();
        if (targetStoreName != null) {
            CCSMAssert.isTrue((boolean)storeNames.contains(targetStoreName), (String)("Store '" + targetStoreName + "' was not found."));
            storeNames = CollectionUtils.asHashSet((Object[])new String[]{targetStoreName});
        }
        for (String storeName : CollectionUtils.sort((Collection)storeNames)) {
            StatisticsCollectingCallback callback = new StatisticsCollectingCallback();
            storageSystem.openStore(storeName).scan(new byte[0], (IKeyValueCallback)callback);
            writer.println(storeName + ";" + callback.toCsvString());
        }
        writer.close();
        return stringWriter.toString();
    }
}

