/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.portfolio.QualityGoalManualAssessment;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.portfolio.PortfolioOverviewService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public interface IPortfolioOverviewService {
    @GET
    @Operation(summary="Get portfolio overview", description="Retrieves the portfolio overview for projects filtered by labels withing a specified time range", tags={"Reporting"})
    @RequiresNoPermission(description="Only projects visible to the user are shown in the overview")
    public List<PortfolioOverviewService.ProjectPortfolioResult> getPortfolioOverview(@Parameter(description="Time range including the start and end commits.") @BeanParam TimeIntervalBasedServiceQueryOptions var1, @Parameter(description="Project portfolio labels to return the overview for.") @QueryParam(value="labels") List<String> var2) throws StorageException;

    @GET
    @Path(value="labels")
    @RequiresNoPermission(description="Only projects visible to the user are returned in the get all queries.")
    @Operation(summary="Get portfolio labels for all projects", tags={"Project"}, description="Returns portfolio labels for all projects.")
    public Set<String> getAllProjectPortfolioLabels() throws StorageException;

    @POST
    @Path(value="manuals/{project}/selected")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Updates the selected manual assessment", tags={"Project"}, description="Updates the currently selected manual assessment for a given project in the portfolio overview.")
    public void updatePortfolioSelectedManualAssessment(@Parameter(description="The id of the project") @PathParam(value="project") PublicProjectId var1, @Parameter(description="The selected manual assessment") @RequestBody QualityGoalManualAssessment var2) throws StorageException;

    @GET
    @Path(value="manuals/{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Returns portfolio manual assessments", tags={"Project"}, description="Returns portfolio quality goal manual assessments for a given project.")
    public List<QualityGoalManualAssessment> getPortfolioManualAssessments(@Parameter(description="The id of the project to which manual assessments belongs") @PathParam(value="project") PublicProjectId var1) throws StorageException;

    @PUT
    @Path(value="manuals/{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Adds new manual assessment", tags={"Project"}, description="Adds a new manual assessment to the list of manual assessments for a given project in the portfolio overview.")
    public void addPortfolioManualAssessment(@Parameter(description="The id of the project") @PathParam(value="project") PublicProjectId var1, @Parameter(description="The new manual assessment") @RequestBody(required=true) QualityGoalManualAssessment var2) throws StorageException;

    @DELETE
    @Path(value="manuals/{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Removes a manual assessment", tags={"Project"}, description="Removes a manual assessment from the list of assessments that belong to a project.")
    public void removePortfolioManualAssessment(@Parameter(description="The id of the project") @PathParam(value="project") PublicProjectId var1, @Parameter(description="The assessment to be removed") @RequestBody(required=true) QualityGoalManualAssessment var2) throws StorageException;
}

