/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.FindingsDescriptionOverrideCache;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/configuration-template")
public class ConfigurationTemplateService
extends ApiBase {
    @GET
    @RequiresNoPermission(description="No specific permissions required to retrieve a configuration template.")
    @Operation(summary="Get configuration template", description="Retrieves the configuration template for given languages.", responses={@ApiResponse(responseCode="404", description="Could not find the requested analysis profile.")})
    public ConfigurationTemplate getConfigurationTemplate(@Parameter(description="Languages to retrieve the configuration template for") @QueryParam(value="language") Set<ELanguage> languages, @Parameter(description="Tools to retrieve the configuration template for") @QueryParam(value="tool") Set<EAnalysisTool> tools, @Parameter(description="Analysis profile to obtain the default values for the configuration template from") @QueryParam(value="profile") String analysisProfileName) {
        try {
            GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
            ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate(languages, tools, globalStorageSystem);
            SynchronizedCacheAccess cacheAccess = this.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(FindingsDescriptionOverrideCache.class);
            template.adjustFindingDescriptionsWithOverrideCache(cacheAccess);
            if (!StringUtils.isEmpty((String)analysisProfileName)) {
                AnalysisProfile analysisProfile = this.getAnalysisProfile(analysisProfileName);
                AnalysisProfileUtils.initDefaultsFromProfile((ConfigurationTemplate)template, (AnalysisProfile)analysisProfile, (GlobalStorageSystem)globalStorageSystem);
            }
            return template;
        }
        catch (ProjectConfigurationException | StorageException e) {
            throw new InternalServerErrorException(e);
        }
    }

    private AnalysisProfile getAnalysisProfile(String analysisProfileName) throws StorageException {
        AnalysisProfile analysisProfile = this.openGlobalIndex(AnalysisProfileIndex.class).getProfile(analysisProfileName);
        if (analysisProfile == null) {
            throw new NotFoundException("No such analysis profile: " + analysisProfileName);
        }
        return analysisProfile;
    }
}

