/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.project.ExternalFindingsSchemaServiceBase;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Path(value="api/external-findings/groups")
public class ExternalFindingsGroupService
extends ExternalFindingsSchemaServiceBase<ExternalAnalysisGroup> {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Get external analysis groups", description="Retrieves all the available analysis groups in the system.", tags={"Findings"})
    public List<ExternalAnalysisGroup> getExternalFindingsGroups() throws StorageException {
        return this.getAllElementsFromIndex();
    }

    @DELETE
    @Path(value="{groupName}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Remove external analysis group", description="Removes the external analysis group identified by the given name.", responses={@ApiResponse(responseCode="404", description="External analysis group with given name could not be found")}, tags={"Findings"})
    public void deleteExternalAnalysisGroup(@Parameter(description="Name of the external analysis group to remove") @PathParam(value="groupName") String groupName) throws StorageException {
        ExternalAnalysisGroup analysisGroup = (ExternalAnalysisGroup)this.getElementWithExistsCheck(groupName);
        this.deleteElement(analysisGroup);
    }

    @PUT
    @Path(value="{groupName}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Update external analysis group", description="Updates the external analysis group identified by the given name.", responses={@ApiResponse(responseCode="404", description="External analysis group with given name could not be found"), @ApiResponse(responseCode="400", description="Inconsistent group name provided.")}, tags={"Findings"})
    public void updateExternalAnalysisGroup(@Parameter(description="Name of the external analysis group to remove") @PathParam(value="groupName") String groupName, @RequestBody(required=true) ExternalAnalysisGroup newValue) throws StorageException {
        ExternalAnalysisGroup analysisGroup = (ExternalAnalysisGroup)this.getElementWithExistsCheck(groupName);
        this.updateElement(analysisGroup, newValue);
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_6_0_0)
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Create external analysis group", description="Creates a new external analysis group.", responses={@ApiResponse(responseCode="400", description="Invalid external analysis group provided.")}, tags={"Findings"})
    public void createExternalAnalysisGroup(@RequestBody(required=true) ExternalAnalysisGroup newValue) throws StorageException {
        this.createElement(newValue);
    }

    @Override
    protected void deleteElement(ExternalAnalysisGroup elementToDelete) throws StorageException {
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        String groupName = elementToDelete.getGroupName();
        storageIndex.deleteGroup(groupName, EAnalysisTool.CUSTOM);
        this.deleteGroupFromAnalysisProfiles(groupName);
    }

    @Override
    protected void updateElement(ExternalAnalysisGroup oldElement, ExternalAnalysisGroup newElement) throws StorageException {
        if (!oldElement.getGroupName().equals(newElement.getGroupName())) {
            throw new BadRequestException("Inconsistent group name in request.");
        }
        this.validateAndStoreAnalysisGroup(newElement, this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class));
    }

    @Override
    protected void createElement(ExternalAnalysisGroup newElement) throws StorageException {
        ExternalFindingsGroupDescriptionIndex findingsGroupDescriptionIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        this.checkGroupNotAlreadyExists(newElement, findingsGroupDescriptionIndex);
        this.validateAndStoreAnalysisGroup(newElement, findingsGroupDescriptionIndex);
    }

    private void validateAndStoreAnalysisGroup(ExternalAnalysisGroup newElement, ExternalFindingsGroupDescriptionIndex findingsGroupDescriptionIndex) throws StorageException {
        ExternalFindingsGroupService.validateGroup(newElement);
        try {
            findingsGroupDescriptionIndex.storeGroups(Collections.singletonList(newElement), EAnalysisTool.CUSTOM);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Could not save finding group", (Throwable)e);
        }
    }

    private void checkGroupNotAlreadyExists(ExternalAnalysisGroup newElement, ExternalFindingsGroupDescriptionIndex findingsGroupDescriptionIndex) throws StorageException {
        try {
            ConfigurationTemplate configurationTemplate = ConfigRegistry.getInstance().createConfigurationTemplate(EnumSet.allOf(ELanguage.class), EnumSet.allOf(EAnalysisTool.class), this.getGlobalStorageSystem());
            HashSet existingGroupNames = new HashSet();
            existingGroupNames.addAll(CollectionUtils.mapToSet((Collection)configurationTemplate.getAnalysisGroups(), AnalysisGroupDescriptor::getName));
            existingGroupNames.addAll(CollectionUtils.mapToSet((Collection)findingsGroupDescriptionIndex.getAllGroups(), ExternalAnalysisGroup::getGroupName));
            if (existingGroupNames.contains(newElement.getGroupName())) {
                throw new StorageException("There already exists an analysis group with the name '" + newElement.getGroupName() + "'");
            }
        }
        catch (ProjectConfigurationException e) {
            throw new InternalServerErrorException("Could not save finding group", (Throwable)e);
        }
    }

    @Override
    protected ExternalAnalysisGroup getElementFromIndex(String externalAnalysisGroupName) throws StorageException {
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        return storageIndex.getGroup(externalAnalysisGroupName, EAnalysisTool.CUSTOM);
    }

    @Override
    protected List<ExternalAnalysisGroup> getAllElementsFromIndex() throws StorageException {
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        return storageIndex.getGroups(EAnalysisTool.CUSTOM);
    }

    @Override
    protected String getName(ExternalAnalysisGroup externalAnalysisGroup) {
        return externalAnalysisGroup.getGroupName();
    }

    private static void validateGroup(ExternalAnalysisGroup group) {
        Optional errorMessage = group.validateIdentifiers();
        if (errorMessage.isPresent()) {
            throw new BadRequestException("Error validating external analysis group " + group.getGroupName() + ": " + (String)errorMessage.get());
        }
        try {
            Pattern.compile(group.getMapping());
        }
        catch (PatternSyntaxException e) {
            throw new BadRequestException("Error validating external analysis group " + group.getGroupName() + ": Invalid regex: \"" + group.getMapping() + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    private void deleteGroupFromAnalysisProfiles(String groupName) throws StorageException {
        AnalysisProfileVersionedIndex versionIndex = this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        UnmodifiableList profileHistories = versionIndex.getAllAnalysisProfileHistories().getSecondList();
        for (AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory historyEntry : profileHistories) {
            AnalysisProfile profile = historyEntry.getProfile(this.getGlobalStorageSystem());
            profile.removeGroupByName(groupName);
            AnalysisProfileUtils.addNewAnalysisProfileVersion((AnalysisProfileVersionedIndex)versionIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)profile, (String)this.getUser().toString(), (String)"Profile updated by System(Delete group from all analysis profiles)", (GlobalStorageSystem)this.getGlobalStorageSystem());
        }
    }
}

