/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.project.ProjectLanguagesServiceUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/file-extensions")
public class ProjectFileExtensionsService
extends ApiBase {
    @GET
    @Operation(summary="Get project file extensions", description="Returns a list of file extensions a project has been configured for", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_5_1, deprecatedSince=ETeamscaleVersion.VERSION_9_6_0)
    public Set<String> getFileExtensions(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        List<ELanguage> projectLanguages = ProjectLanguagesServiceUtils.getProjectLanguages(this.getIndexLayer(), projectId);
        HashSet<String> extensions = new HashSet<String>();
        for (ELanguage language : projectLanguages) {
            extensions.addAll(Arrays.asList(language.getFileExtensions()));
        }
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)this.getIndexLayer());
        UnmodifiableList connectors = projectConfiguration.getConnectors();
        for (ConnectorConfiguration connector : connectors) {
            String languageMappingOption = connector.getOptionValue("Language mapping");
            if (StringUtils.isEmpty((String)languageMappingOption)) continue;
            extensions.addAll(ProjectFileExtensionsService.extractFileExtensions(languageMappingOption));
        }
        return extensions;
    }

    private static Set<String> extractFileExtensions(String languageMappingOption) throws StorageException {
        try {
            HashSet<String> extensions = new HashSet<String>();
            PairList mappings = StringValuePairListOptionDescriptor.parseFromString((String)languageMappingOption);
            for (String mapping : mappings.extractFirstList()) {
                String extension = StringUtils.getLastPart((String)mapping, (char)'.');
                if (StringUtils.isEmpty((String)extension)) continue;
                extensions.add(extension);
            }
            return extensions;
        }
        catch (ProjectConfigurationException e) {
            throw new StorageException((Throwable)e);
        }
    }
}

