/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.reports.slides.ISlideRenderer;
import com.teamscale.service.reports.slides.SlideRenderContext;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;

public abstract class SlideRendererBase<Parameters extends SlideParametersBase>
implements ISlideRenderer {
    protected final SlideRenderContext<Parameters> renderContext;

    public SlideRendererBase(SlideRenderContext<Parameters> renderContext) {
        this.renderContext = renderContext;
    }

    protected Parameters getParameters() {
        return this.renderContext.getParameters();
    }

    protected QualityArtifactProfile getReportProfile() {
        return this.renderContext.getReportProfile();
    }

    protected List<SlideCommentRenderData> getSlideCommentRenderData(@Nullable ProjectBranchPath projectBranchPath, List<ISlideComment> comments) throws StorageException {
        if (projectBranchPath == null) {
            projectBranchPath = this.renderContext.getReportProfile().getDefaultProjectSetting();
        }
        TimeRange timeRange = this.getTimeRange(projectBranchPath);
        ArrayList<SlideCommentRenderData> data = new ArrayList<SlideCommentRenderData>();
        for (ISlideComment comment : comments) {
            data.add(comment.calculateRenderData(this.renderContext.getIndexLayer(), projectBranchPath, timeRange.start(), timeRange.end()));
        }
        return data;
    }

    private @NonNull TimeRange getTimeRange(ProjectBranchPath projectBranchPath) throws StorageException {
        UnresolvedCommitDescriptor start = new UnresolvedCommitDescriptor(projectBranchPath.getBranch(), this.getReportProfile().getBaselineWithType().getTimestamp());
        UnresolvedCommitDescriptor end = new UnresolvedCommitDescriptor(projectBranchPath.getBranch(), this.getReportProfile().getEndWithType().getTimestamp());
        IFactory projectStorageSystemFactory = () -> this.renderContext.getIndexLayer().openProjectStorageSystem((IProjectId)projectBranchPath.getProjectId());
        CommitDescriptor startCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)start, (IFactory)projectStorageSystemFactory);
        CommitDescriptor endCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)end, (IFactory)projectStorageSystemFactory);
        return new TimeRange(startCommit, endCommit);
    }
}

