/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class CoverageServiceBase
extends ApiBase {
    protected static boolean isPathIgnoredForCoverage(UniformPath uniformPath) {
        return !uniformPath.isCodePath();
    }

    protected List<String> getRelevantCoveragePartitions(MergeRequestIdentifier mergeRequestId, UnresolvedCommitDescriptor commit, CoverageSourceQueryParameters coverageSourceParameters) throws StorageException, CommitResolutionException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        LineCoverageIndex lineCoverageIndex = this.openProjectIndex(LineCoverageIndex.class, historyAccessOption);
        List allPartitions = lineCoverageIndex.getPartitions();
        if (mergeRequestId != null && EFeatureToggle.USE_COVERABLE_LINES_FROM_COVERAGE_REPORTS.isEnabled()) {
            List<String> relevantPartitions = this.getUpdatedTestCoveragePartitions(mergeRequestId, allPartitions, historyAccessOption);
            return coverageSourceParameters.getPartitions(relevantPartitions);
        }
        return coverageSourceParameters.getPartitions((Collection)allPartitions);
    }

    private List<String> getUpdatedTestCoveragePartitions(MergeRequestIdentifier mergeRequestId, List<String> allTestCoveragePartitions, HistoryAccessOption sourceAccessOption) throws StorageException, CommitResolutionException {
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        MergeRequest mergeRequest = (MergeRequest)mergeRequestIndex.getMergeRequest(mergeRequestId).orElseThrow(() -> new NotFoundException("Merge request " + String.valueOf(mergeRequestId) + " not found"));
        CommitDescriptor sourceCommit = CommitDescriptor.latestOnBranch((String)mergeRequest.getSourceBranch());
        CommitDescriptor targetCommit = CommitDescriptor.latestOnBranch((String)mergeRequest.getTargetBranch());
        CommitDescriptorIndex commitDescriptorIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        MergeBaseInfo mergeBaseInfo = (MergeBaseInfo)MergeBaseResolver.computeMergeBaseInfo((CommitDescriptor)sourceCommit, (CommitDescriptor)targetCommit, (CommitDescriptorIndex)commitDescriptorIndex).orElseThrow(() -> new BadRequestException("Could not find a common ancestor commit for " + String.valueOf(sourceCommit) + " and " + String.valueOf(targetCommit) + ". Maybe the analyzed history is too short?"));
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        List relevantCommits = MergeRequestUtils.determineRelevantCommitsInMergeRequest((RepositoryLogIndex)repositoryLogIndex, (MergeBaseInfo)mergeBaseInfo);
        ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex = this.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, sourceAccessOption);
        return MergeRequestUtils.getUpdatedTestCoveragePartitions((ExternalResultsPartitionLastUpdateIndex)externalResultsPartitionLastUpdateIndex, (List)relevantCommits, allTestCoveragePartitions);
    }

    protected LineCoverageInfo loadAndMergeCoverageData(UniformPath uniformPath, List<String> partitions, HistoryAccessOption historyAccessOption, boolean includeMethodAccurateCoverage) throws StorageException {
        LineCoverageIndex coverageIndex = this.openProjectIndex(LineCoverageIndex.class, historyAccessOption);
        List coverageInfos = coverageIndex.getAllCoverageForFile(partitions, uniformPath);
        boolean hasNoCoverage = CollectionUtils.allMatch((Collection)coverageInfos, Objects::isNull);
        if (hasNoCoverage) {
            return null;
        }
        LineCoverageInfo result = new LineCoverageInfo(false);
        for (LineCoverageInfo coverageInfo : coverageInfos) {
            if (coverageInfo == null || !CoverageServiceBase.shouldBeIncluded(coverageInfo, includeMethodAccurateCoverage)) continue;
            result.addAll(coverageInfo);
            result.setMethodAccurate(result.isMethodAccurate() || coverageInfo.isMethodAccurate());
        }
        return result;
    }

    private static boolean shouldBeIncluded(LineCoverageInfo coverageInfo, boolean includeMethodAccurateCoverage) {
        return !coverageInfo.isMethodAccurate() || includeMethodAccurateCoverage;
    }
}

