/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.teamscale.core.options.DataPrivacyOption;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.user.UserAliasLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class CommitSearchFilter
implements BiPredicate<IProjectId, IRepositoryLogEntry> {
    private final Map<IProjectId, Boolean> projectAccessCache;
    private final UserAliasLookup userAliasLookup;
    private final String username;
    private final ServicePermissions permissions;
    private final boolean isPrivacyOptionActive;

    public CommitSearchFilter(GlobalStorageSystem globalStorageSystem, String username, ServicePermissions servicePermissions) throws StorageException {
        this.isPrivacyOptionActive = DataPrivacyOption.getDataPrivacyOption((GlobalStorageSystem)globalStorageSystem).limitDevelopersLogToOwnCommits;
        this.userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)globalStorageSystem);
        this.permissions = servicePermissions;
        this.username = username;
        this.projectAccessCache = new HashMap<IProjectId, Boolean>();
    }

    @Override
    public boolean test(IProjectId project, IRepositoryLogEntry entry) {
        if (!this.isPrivacyOptionActive || this.mayViewAllUserData(project)) {
            return true;
        }
        return this.username.equals(this.userAliasLookup.resolveAuthorOf(entry).map(User::getUsername).orElse(entry.getAuthor()));
    }

    private boolean mayViewAllUserData(IProjectId project) {
        if (this.projectAccessCache.containsKey(project)) {
            return this.projectAccessCache.get(project);
        }
        try {
            boolean permission = this.permissions.userHasProjectPermission(project, EProjectPermission.VIEW_ALL_USER_DATA);
            this.projectAccessCache.put(project, permission);
            return permission;
        }
        catch (StorageException e) {
            return false;
        }
    }
}

