/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.simulink.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Path(value="api/projects/{project}/simulink/debug/file-references")
public class DebugSimulinkFileReferencesService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get Simulink File References", description="Returns references from simulink files to other simulink files (e.g., references from models to library blocks)", tags={"Debugging", "Simulink"})
    public String getResolvedSimulinkOutputDataTypes(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        BinaryElementIndex index = (BinaryElementIndex)this.getProjectStorageSystem().openProjectIndex(BinaryElementIndex.class, this.determineHistoryOption(commit));
        LazyModelLoader modelLoader = new LazyModelLoader(index);
        ArrayList<SimulinkModel> models = new ArrayList<SimulinkModel>();
        for (Object uniformPath : index.getAllElements()) {
            Optional optional;
            if (!((String)uniformPath).endsWith(".slx") || !(optional = modelLoader.getModelByUniformPath((String)uniformPath)).isPresent()) continue;
            models.add((SimulinkModel)optional.get());
        }
        HashMap<String, List<SimulinkFileReference>> references = new HashMap<String, List<SimulinkFileReference>>();
        for (SimulinkModel simulinkModel : models) {
            references.put(simulinkModel.getUniformPath(), this.extractReferencesForModel(simulinkModel));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry referencesinFile : references.entrySet()) {
            sb.append((String)referencesinFile.getKey()).append("\n");
            for (SimulinkFileReference reference : (List)referencesinFile.getValue()) {
                sb.append("    ").append(reference.referenceSourceBlockQualifiedName).append(" -> ").append((Object)reference.value.type).append(" ").append(reference.value.name).append(" ").append("\n");
            }
        }
        return sb.toString();
    }

    private @NonNull List<SimulinkFileReference> extractReferencesForModel(SimulinkModel model) {
        String uniformPath = model.getUniformPath();
        ArrayList<SimulinkFileReference> references = new ArrayList<SimulinkFileReference>();
        references.addAll(DebugSimulinkFileReferencesService.buildReferencesFromModelToModel(uniformPath, model));
        return references;
    }

    private static List<SimulinkFileReference> buildReferencesFromModelToModel(String originUniformPath, SimulinkModel originModel) {
        ArrayList<SimulinkFileReference> references = new ArrayList<SimulinkFileReference>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)originModel, (boolean)false, (boolean)false)) {
            String sourceBlockId;
            if (block.isOfType("SubSystem")) {
                String sourceFileId = block.getParameter("ReferencedSubsystem");
                references.add(new SimulinkFileReference(originUniformPath, block.buildQualifiedName(), new ReferencedItem(ReferencedItem.EReferencedItemType.MODEL_FILE, sourceFileId)));
                continue;
            }
            if (!block.isOfType("Reference") || (sourceBlockId = block.getParameter("SourceBlock")) == null) continue;
            sourceBlockId = sourceBlockId.replace("\\\\n", " ");
            references.add(new SimulinkFileReference(originUniformPath, block.buildQualifiedName(), new ReferencedItem(ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY, sourceBlockId)));
        }
        return references;
    }

    private record SimulinkFileReference(String referenceSourceUniformPath, String referenceSourceBlockQualifiedName, ReferencedItem value) {
    }

    private record ReferencedItem(EReferencedItemType type, String name) {

        private static enum EReferencedItemType {
            BLOCK_IN_LIBRARY("LIB_BLOCK:"),
            MODEL_FILE("MODEL_NAME:");

            private final String storageKey;

            private EReferencedItemType(String storageKey) {
                this.storageKey = storageKey;
            }
        }
    }
}

