/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.health;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class HealthMetricsUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static double getWorkerLoad(IndexLayer indexLayer) throws StorageException {
        List statuses = ((WorkerIndex)indexLayer.openGlobalIndex(WorkerIndex.class)).getWorkerClusterStatusAccess().listAll();
        int workerCount = HealthMetricsUtils.getWorkerCount(indexLayer);
        double utilizationSum = statuses.stream().map(WorkerClusterStatus::getWorkerLoad).reduce(Double::sum).orElse(0.0);
        return utilizationSum / (double)Math.max(1, workerCount);
    }

    public static int getWorkerCount(IndexLayer indexLayer) throws StorageException {
        List statuses = ((WorkerIndex)indexLayer.openGlobalIndex(WorkerIndex.class)).getWorkerClusterStatusAccess().listAll();
        return statuses.stream().map(WorkerClusterStatus::getWorkerCount).reduce(Integer::sum).orElse(0);
    }

    public static TwoDimHashMap<String, String, Double> collectWorkerRuntime(IndexLayer indexLayer) {
        try {
            List statuses = ((WorkerIndex)indexLayer.openGlobalIndex(WorkerIndex.class)).getWorkerClusterStatusAccess().listAll();
            return HealthMetricsUtils.collectWorkerRuntimeByClusterStatuses(statuses);
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve worker runtime metrics.", (Throwable)e);
            return new TwoDimHashMap();
        }
    }

    private static TwoDimHashMap<String, String, Double> collectWorkerRuntimeByClusterStatuses(List<WorkerClusterStatus> statuses) {
        TwoDimHashMap result = new TwoDimHashMap();
        for (WorkerClusterStatus status : statuses) {
            for (WorkerClusterStatus.WorkerThreadStatus threadStatus : status.getThreadStatuses()) {
                double runtime = HealthMetricsUtils.getRuntime(threadStatus);
                result.putValue((Object)status.getProcessId(), (Object)threadStatus.getWorkerId(), (Object)runtime);
            }
        }
        return result;
    }

    private static double getRuntime(WorkerClusterStatus.WorkerThreadStatus threadStatus) {
        double runtime = 0.0;
        if (threadStatus.getRunState() != WorkerClusterStatus.WorkerThreadStatus.EWorkerThreadRunStatus.IDLE) {
            runtime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - threadStatus.getStartTimestamp());
        }
        return runtime;
    }

    private HealthMetricsUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

