/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.health;

import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SystemHealthUtils {
    public static <E extends Enum<E>> List<E> determineChecksOrMetrics(List<String> checkOrMetricParameters, Class<E> clazz) {
        if (checkOrMetricParameters == null || checkOrMetricParameters.size() == 0) {
            return Arrays.asList((Enum[])clazz.getEnumConstants());
        }
        ArrayList<Enum> checksOrMetrics = new ArrayList<Enum>();
        for (String parameter : checkOrMetricParameters) {
            Enum checkOrMetric = EnumUtils.valueOfIgnoreCase(clazz, (String)parameter);
            if (checkOrMetric == null) {
                throw new BadRequestException("Unknown check/metric name: " + parameter);
            }
            checksOrMetrics.add(checkOrMetric);
        }
        return checksOrMetrics;
    }

    private SystemHealthUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

